% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_methods.R
\name{BCSreg-methods}
\alias{BCSreg-methods}
\alias{model.frame.BCSreg}
\alias{model.matrix.BCSreg}
\alias{coef.BCSreg}
\alias{vcov.BCSreg}
\alias{logLik.BCSreg}
\alias{AIC.ugrpl}
\title{Extract Information From a Box-Cox Symmetric Regression Fit}
\usage{
\method{model.frame}{BCSreg}(formula, ...)

\method{model.matrix}{BCSreg}(object, model = c("mu", "sigma", "alpha"), ...)

\method{coef}{BCSreg}(object, model = c("mu", "sigma", "alpha", "full"), ...)

\method{vcov}{BCSreg}(object, model = c("mu", "sigma", "alpha", "full"), ...)

\method{logLik}{BCSreg}(object, ...)

\method{AIC}{ugrpl}(object, ..., k = 2)
}
\arguments{
\item{formula}{a model formula or terms object or an R object.}

\item{...}{further arguments passed to or from other methods.}

\item{object}{an object of class \code{"BCSreg"}, a result of a call to \link{BCSreg}.}

\item{model}{a character indicating which regression structure should be used.
It can be \code{"mu"} for the scale regression structure, \code{"sigma"} for
the relative dispersion regression structure, or \code{"full"} (when applicable)
for both regression structures.}

\item{k}{numeric, the penalty per parameter to be used; the default
\code{k = 2} is the classical Akaike information criteria (AIC).}
}
\value{
\itemize{
\item \code{model.frame} returns a \code{data.frame} containing the variables required
    by \code{formula} and any additional arguments provided via \code{...}.
\item \code{model.matrix} returns the design matrix used in the regression structure,
    as specified by the \code{model} argument.
\item \code{coef} returns a numeric vector of estimated regression coefficients, based
    on the \code{model} argument. If \code{parm = "full"}, it returns a list with the
    components \code{"mu"} and \code{"sigma"}, each containing the corresponding
    coefficient estimates. If the model is zero-adjusted, it will also have a
    \code{"alpha"} component with the estimates of the associated regression coefficients.
\item \code{vcov} returns the asymptotic covariance matrix of the regression coefficients,
    based on the \code{model} argument.
\item \code{logLik} returns the log-likelihood value of the fitted model.
\item \code{AIC} returns a numeric value representing the Akaike Information Criterion
    (AIC), Bayesian Information Criterion, or another criterion, depending on \code{k}.
}
}
\description{
Methods for \code{"BCSreg"} objects.
}
\examples{
## Data set: renewables2015 (for description, run ?renewables2015)
plot(ecdf(renewables2015$renew_elec_output), cex = 0.3, main = "Empirical CDF")
abline(h = mean(renewables2015$renew_elec_output == 0), col = "grey", lty = 3)
text(1250, 0.155, paste0("prop. of zeros: ~0.12"), col = "blue")

plot(renew_elec_output ~ adj_sav_edu, renewables2015, pch = 16,
    xlab = "Education expenditure (percent of GNI)",
    ylab = "Renewable electricity output (in TWh)")
plot(renew_elec_output ~ agri_land, renewables2015, pch = 16,
    xlab = "Matural logarithm of total agricultural land area",
    ylab = "Renewable electricity output (in TWh)")

 ## Fit a zero-adjusted Box-Cox normal regression
 fit <- BCSreg(renew_elec_output ~ adj_sav_edu + agri_land |
                 adj_sav_edu + agri_land |
                 adj_sav_edu + agri_land, renewables2015)

 ## coef
 coef(fit)                  # regression coefficients of the scale submodel
 coef(fit, model = "sigma") # regression coefficients of the relative dispersion submodel
 coef(fit, model = "alpha") # regression coefficients of the zero-adjustment submodel
 coef(fit, model = "full")  # all regression coefficients

 ## vcov
 vcov(fit)                  # covariance matrix for the scale submodel coefficients
 vcov(fit, model = "sigma") # covariance matrix for the relative dispersion submodel coefficients
 vcov(fit, model = "alpha") # covariance matrix for the zero-adjustment submodel coefficients
 vcov(fit, model = "full")  # full covariance matrix of the model (including the skewness parameter)

 ## Log-likelihood value
 logLik(fit)

 ## AIC and BIC
 AIC(fit)
 AIC(fit, k = log(fit$nobs))

 ## Model matrices
 model.matrix(fit)                  # design matrix for the scale submodel
 model.matrix(fit, model = "sigma") # design matrix for the relative dispersion submodel
 model.matrix(fit, model = "alpha") # design matrix for the zero-adjustment submodel
}
\references{
Ferrari, S. L. P., and Fumes, G. (2017). Box-Cox symmetric distributions and
    applications to nutritional data. \emph{AStA Advances in Statistical Analysis},
    \bold{101}, 321---344.

    Medeiros, R. M. R., and Queiroz, F. F. (2025). Flexible modeling of nonnegative continuous
    data: Box-Cox symmetric regression and its zero-adjusted extension.
}
\author{
Francisco F. de Queiroz <\email{felipeq@ime.usp.br}>

Rodrigo M. R. de Medeiros <\email{rodrigo.matheus@ufrn.br}>
}
