% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updog2vcf.R
\name{updog2vcf}
\alias{updog2vcf}
\title{Export Updog Results as VCF}
\usage{
updog2vcf(
  multidog.object,
  output.file,
  updog_version = NULL,
  RefAlt = NULL,
  compress = TRUE
)
}
\arguments{
\item{multidog.object}{updog output object with class "multidog" from dosage calling}

\item{output.file}{output file name and path}

\item{updog_version}{character defining updog package version used to generate the multidog object}

\item{RefAlt}{optional data frame with four columns named "Chr", "Pos", "Ref", and "Alt" containing the reference and alternate alleles for each SNP in the same order as in the multidog object}

\item{compress}{logical. If TRUE returns a vcf.gz file}
}
\value{
A vcf file
}
\description{
This function will convert an Updog output to a VCF file
}
\details{
When performing dosage calling for multiple SNPs using Updog, the output file contains information for all loci and all samples.
This function will convert the updog output file to a VCF file, while retaining the information for the values that are commonly
used to filter low quality and low confident dosage calls.
}
\examples{

# Retrieving the updog output multidog object
load(system.file("extdata", "iris-multidog.rdata", package = "BIGr"))

temp_file <- tempfile()

# Convert updog to VCF, where the new VCF will be saved at the location specified in the output.file
updog2vcf(
  multidog.object = mout,
  output.file = temp_file,
  updog_version = "0.0.0",
  compress = TRUE
)

#Removing the example vcf
rm(temp_file)

}
\references{
Gerard, D., Ferrão, L. F. V., Garcia, A. A. F., & Stephens, M. (2018). Genotyping polyploids from messy sequencing data. Genetics, 210(3), 789-807.
}
