% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examples.R
\name{BixiData}
\alias{BixiData}
\title{BIXI Data Class}
\description{
R6 class encapsulating all BIXI dataframes. It is also
possible to use a light version of the dataset by using the \code{is_light}
parameter. In this case, the dataset is reduced to its first 25 stations
and first 50 days. The light version is only used for testing and short examples.
}
\examples{
# Create a light BIXI data collection instance containing multiple dataframes
# This only uses the first 25 stations and 50 days of the full dataset
bixi_data <- BixiData$new(is_light = TRUE)
# Dataframe containing the position (latitude and longitude) of M stations
bixi_data$spatial_positions_df
# Dataframe containing the time position of N days (O to N-1)
bixi_data$temporal_positions_df
# Dataframe with spatial and temporal features for each day and station (M x N rows)
bixi_data$data_df

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{departure_df}}{The departure dataframe}

\item{\code{spatial_features_df}}{The spatial features dataframe}

\item{\code{temporal_features_df}}{The temporal features dataframe}

\item{\code{spatial_positions_df}}{The spatial positions dataframe}

\item{\code{temporal_positions_df}}{The temporal positions dataframe}

\item{\code{data_df}}{The data dataframe}

\item{\code{is_light}}{Whether the light version of the dataset is used}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BixiData-new}{\code{BixiData$new()}}
\item \href{#method-BixiData-clone}{\code{BixiData$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BixiData-new"></a>}}
\if{latex}{\out{\hypertarget{method-BixiData-new}{}}}
\subsection{Method \code{new()}}{
Initialize the BIXI data class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BixiData$new(is_light = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{is_light}}{Whether the light version of the dataset is used,
defaults to FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new BIXI data instance
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BixiData-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BixiData-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BixiData$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
