% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Components.R
\name{Components}
\alias{Components}
\alias{AddComponents}
\alias{RemoveComponents}
\alias{AddInComps}
\alias{RemoveInComps}
\alias{AddDefComps}
\alias{RemoveDefComps}
\title{Add or remove components in the problem}
\usage{
AddComponents(
  ThisProblem,
  CompName,
  CompCharge,
  CompMCName = NULL,
  CompType,
  CompActCorr,
  CompSiteDens = 1,
  CompMCR = match(CompMCName, ThisProblem$Mass$Name, nomatch = -1L),
  DoCheck = TRUE
)

RemoveComponents(ThisProblem, ComponentToRemove, DoCheck = TRUE)

AddInComps(
  ThisProblem,
  InCompName,
  InCompCharge,
  InCompMCName = NULL,
  InCompType,
  InCompActCorr,
  InCompMCR = match(InCompMCName, ThisProblem$Mass$Name, nomatch = -1L),
  DoCheck = TRUE
)

RemoveInComps(ThisProblem, InCompToRemove, DoCheck = TRUE)

AddDefComps(
  ThisProblem,
  DefCompName,
  DefCompFromNum = NULL,
  DefCompFromVar = NULL,
  DefCompCharge,
  DefCompMCName = NULL,
  DefCompType,
  DefCompActCorr,
  DefCompSiteDens,
  DefCompMCR = match(DefCompMCName, ThisProblem$Mass$Name, nomatch = -1L),
  InDefComp = TRUE,
  DoCheck = TRUE
)

RemoveDefComps(ThisProblem, DefCompToRemove, DoCheck = TRUE)
}
\arguments{
\item{ThisProblem}{A list object with a structure like that returned by
`BlankProblem()`.}

\item{CompName, InCompName, DefCompName}{A character vector with the name(s) of
the components to be added.}

\item{CompCharge, InCompCharge, DefCompCharge}{An integer vector with the
charge(s) of the components to be added.}

\item{CompMCName, InCompMCName, DefCompMCName}{A character vector with the
name(s) of the mass compartments the new components are associated with.
Does not need to be specified if `CompMCR`/`InCompMCR`/`DefCompMCR` is
specified instead.}

\item{CompType, InCompType, DefCompType}{A character vector with the types of
the new input variables. Must be one of "MassBal", "FixedAct", "FixedConc",
"DonnanHA", or "DonnanFA".}

\item{CompActCorr, InCompActCorr, DefCompActCorr}{A character vector with the
activity correction method(s) of the new components. Must be one of "None",
"Debye", "Davies", "DonnanHA", "DonnanFA", "WHAMHA", or "WHAMFA".
Generally, "DonnanHA", "DonnanFA", "WHAMHA", and "WHAMFA" will only be used
internally.}

\item{CompSiteDens, DefCompSiteDens}{A numeric vector with the binding site
densities of the new components. `AddInComps` assumes a site density of
1.0.}

\item{CompMCR, InCompMCR, DefCompMCR}{(optional) A character vector with the
indices of the mass compartments the new components are associated with.
Only needs to be specified if `CompMCName`/`InCompMCName`/`DefCompMCName`
is not specified.}

\item{DoCheck}{A logical value indicating whether checks should be performed
on the incoming and outgoing problem objects. Defaults to `TRUE`, as you
usually want to make sure something isn't awry, but the value is often set
to `FALSE` when used internally (like in DefineProblem) so the problem is
only checked once at the end.}

\item{ComponentToRemove, InCompToRemove, DefCompToRemove}{A character vector
with names or indices of the component(s) to remove from `ThisProblem`. It
is safer to use a name, since the index of the component may be different
within `ThisProblem$Comp$Name` versus `ThisProblem$InCompName` versus
`ThisProblem$DefComp$Name`.}

\item{DefCompFromNum}{A numeric vector with the numeric values used to derive
the component. Specify `NA` if the defined component uses a variable to
define it.}

\item{DefCompFromVar}{A character vector with the variable names used to
derive the component. Specify `NA` if the defined component uses a number
to define it.}

\item{InDefComp}{A logical value indicating if this is a defined component
from the parameter file (`TRUE`) or was added from another process, such as
`ExpandWHAM` (`FALSE`).}
}
\value{
`ThisProblem`, with the edits done to the component list, including
  "trickle-down" changes, such as removing formation reactions that used a
  now-removed component.
}
\description{
A component should be added either as an input component (with
  `AddInComps`) or a defined component (with `AddDefComps`). Both of those
  functions will call the `AddComponents` function, but using either
  `AddInComps` and `AddDefComps` ensures that it's very clear where the
  inputs come from.
}
\examples{
print(carbonate_system_problem$Comp)
my_new_problem = carbonate_system_problem
my_new_problem = AddInComps(ThisProblem = my_new_problem,
                            InCompName = "Ca",
                            InCompCharge = 2,
                            InCompMCName = "Water",
                            InCompType = "MassBal",
                            InCompActCorr = "Debye")
print(my_new_problem$Comp)
}
\seealso{
The in-depth example in [BlankProblem()] will show all problem
  manipulation functions in use.

Other problem manipulation functions: 
\code{\link{BlankProblem}()},
\code{\link{CriticalValues}},
\code{\link{InLabs}},
\code{\link{InVars}},
\code{\link{MassCompartments}},
\code{\link{Phases}},
\code{\link{SpecialDefs}},
\code{\link{Species}}
}
\concept{problem manipulation functions}
