# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Geodesic distance
#' @description Evaluate geodesic distance (shortest path) between all pairs of nodes in the network.
#'
#' @param M Input adjacency matrix
#'
#' @return Matrix containing all the pairwise geodesic distances
#' @examples dst(example_adjacency_matrix)
#' @export
dst <- function(M) {
    .Call(`_BLSM_dst`, M)
}

#' @title Distance between latent positions
#' @description Compute the square root of the Euclidean distances between latent positions and 
#' return them with a negative sign.
#'
#' @param Z Latent positions matrix. The matrix size must be \code{(n,k)}, where \code{n} and \code{k} denote respectively 
#' the number of nodes in the network and the latent space dimensionality.
#' @return Matrix containing the negative square root of the Euclidean distances between latent positions
#' @examples pos = matrix(rnorm(20), ncol=2)
#' lpz_dist(pos)
#' @export
lpz_dist <- function(Z) {
    .Call(`_BLSM_lpz_dist`, Z)
}

#' @title Network log-likelihood
#' @description Compute the log-likelihood of the whole observed network based on the
#' latent positions estimates and the model assumptions. See \link[BLSM]{BLSM} for more information. 
#' 
#' @param Y Adjacency matrix of the observed network
#' @param lpz Matrix containing the negative square root of the Euclidean distances between latent positions 
#' (output of \link[BLSM]{lpz_dist})
#' @param alpha Model variable \eqn{\alpha}
#' @param W BLSM Weights matrix of the observed network
#' 
#' @return Log-likelihood of the observed network
lpY <- function(Y, lpz, alpha, W) {
    .Call(`_BLSM_lpY`, Y, lpz, alpha, W)
}

#' @title Network (positive) log-likelihood 
#' @description Compute the (positive) log-likelihood of the whole observed network based on the
#' latent positions estimates and the model assumptions. The inputs are slightly different from those of \link[BLSM]{lpY},
#' so the function basically applies some preprocessing before calling \link[BLSM]{lpY} and returning its value with the opposite sign. 
#' 
#' @param avZ Vector containing the \eqn{\alpha} value and the latent positions 
#' @param Y Adjacency matrix of the observed network
#' @param W BLSM Weights matrix of the observed network
#' 
#' @return Log-likelihood of the observed network
mlpY <- function(avZ, Y, W) {
    .Call(`_BLSM_mlpY`, avZ, Y, W)
}

#' @title lpz_dist optimized for individual updates
#' @description Compute the square root of the Euclidean distances between a specific coordinate in the latent space
#' and all the others. The function follows almost the same approach as \link[BLSM]{lpz_dist}, but it is
#' more suitable for the individual updates occurring during the simulation.
#' 
#' @param Z Latent positions matrix
#' @param node Specific node in the network corresponding to the latent coordinate which will be used as reference
#' @param diag Diagonal from \code{t(Z)\%*\%Z} matrix, passed to speed up the process.
#' @return Vector containing the negative square root of the Euclidean distances between latent positions
lpz_distNODE <- function(Z, node, diag) {
    .Call(`_BLSM_lpz_distNODE`, Z, node, diag)
}

#' @title Network log-likelihood for individual updates
#' @description Compute the log-likelihood of the whole observed network based on the
#' latent positions estimates and the model assumptions. The function follows almost the same approach as \link[BLSM]{lpY}, but it is
#' more suitable for the individual updates occurring during the simulation.
#' @param Y Adjacency matrix of the observed network
#' @param Z Latent positions matrix
#' @param alpha Model variable \eqn{\alpha}
#' @param node Specific node in the network corresponding to the latent coordinate which will be used as reference
#' @param diag Diagonal from \code{t(Z)\%*\%Z} matrix, passed to speed up the process.
#' @param W BLSM Weights matrix of the observed network
#' 
#' @return Log-likelihood of the observed network
lpYNODE <- function(Y, Z, alpha, node, diag, W) {
    .Call(`_BLSM_lpYNODE`, Y, Z, alpha, node, diag, W)
}

#' @title Update step for the latent positions
#' @description Accept/reject the proposals for the latent positions
#'  
#' @param Y Adjacency matrix of the observed network
#' @param Z Latent positions matrix
#' @param W BLSM Weights matrix of the observed network
#' @param alpha Model variable \eqn{\alpha}
#' @param zdelta Standard deviation of the Gaussian proposal for latent positions
#' @param mu_z Mean of the Gaussian prior distribution for latent positions 
#' @param sd_z Standard deviation of the Gaussian prior distribution for latent positions
#' 
#' @return Updated latent positions matrix
Z_up <- function(Y, Z, W, alpha, zdelta, mu_z, sd_z) {
    .Call(`_BLSM_Z_up`, Y, Z, W, alpha, zdelta, mu_z, sd_z)
}

#' @title Update step for the \eqn{\alpha} variable
#' @description Accept/reject the proposal for the \eqn{\alpha} model variable 
#'  
#' @param Y Adjacency matrix of the observed network
#' @param lpz Matrix containing the negative square root of the Euclidean distances between latent positions 
#' @param W BLSM Weights matrix of the observed network
#' @param alpha Model variable \eqn{\alpha}
#' @param adelta The uniform proposal for \eqn{\alpha} is defined on the \eqn{[-adelta,+adelta]} interval
#' @param a_a Shape parameter of the Gamma prior distribution for \eqn{\alpha}. The value is usually set to 1, so the prior is actually an exponential distribution.
#' @param a_b Rate parameter of the Gamma prior distribution for \eqn{\alpha}. 
#' 
#' @return Updated value of the \eqn{\alpha} variable
alpha_up <- function(Y, lpz, W, alpha, adelta, a_a, a_b) {
    .Call(`_BLSM_alpha_up`, Y, lpz, W, alpha, adelta, a_a, a_b)
}

