% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMTkurtosis.R
\name{BMTkurtosis}
\alias{BMTkurtosis}
\alias{BMTkurt}
\alias{BMTsteep}
\title{The BMT Distribution Descriptive Measures - Kurtosis.}
\usage{
BMTkurt(p3, p4, type.p.3.4 = "t w", p1 = 0, p2 = 1, type.p.1.2 = "c-d")

BMTsteep(p3, p4, type.p.3.4 = "t w", p1 = 0, p2 = 1, type.p.1.2 = "c-d")
}
\arguments{
\item{p3, p4}{tails weights (\eqn{\kappa_l} and \eqn{\kappa_r}) or 
asymmetry-steepness (\eqn{\zeta} and \eqn{\xi}) parameters of the BMT 
distribution.}

\item{type.p.3.4}{type of parametrization associated to p3 and p4. "t w" means
tails weights parametrization (default) and "a-s" means asymmetry-steepness
parametrization.}

\item{p1, p2}{domain (minimum and maximum) or location-scale (mean and 
standard deviation) parameters of the BMT distribution.}

\item{type.p.1.2}{type of parametrization associated to p1 and p2. "c-d" means
domain parametrization (default) and "l-s" means location-scale 
parametrization.}
}
\value{
\code{BMTkurt} gives the Pearson's kurtosis and \code{BMTsteep} the 
  proposed steepness coefficient for the BMT distribution.
  
  The arguments are recycled to the length of the result. Only the first 
  elements of \code{type.p.3.4} and \code{type.p.1.2} are used.
  
  If \code{type.p.3.4 == "t w"}, \code{p3 < 0} and \code{p3 > 1} are errors 
  and return \code{NaN}.
  
  If \code{type.p.3.4 == "a-s"}, \code{p3 < -1} and \code{p3 > 1} are errors 
  and return \code{NaN}.
  
  \code{p4 < 0} and \code{p4 > 1} are errors and return \code{NaN}.
  
  If \code{type.p.1.2 == "c-d"}, \code{p1 >= p2} is an error and returns 
  \code{NaN}.
  
  If \code{type.p.1.2 == "l-s"}, \code{p2 <= 0} is an error and returns 
  \code{NaN}.
}
\description{
Kurtosis and steepness coefficient for the BMT distribution with
  \code{p3} and \code{p4} tails weights (\eqn{\kappa_l} and \eqn{\kappa_r})
  or asymmetry-steepness parameters (\eqn{\zeta} and \eqn{\xi}) and \code{p1}
  and \code{p2} domain (minimum and maximum) or location-scale (mean and 
  standard deviation) parameters.
}
\details{
See References.
}
\examples{
# BMT on [0,1] with left tail weight equal to 0.25 and 
# right tail weight equal to 0.75
BMTkurt(0.25, 0.75, "t w")
BMTsteep(0.25, 0.75, "t w")

# BMT on [0,1] with asymmetry coefficient equal to 0.5 and 
# steepness coefficient equal to 0.75
BMTkurt(0.5, 0.5, "a-s")
BMTsteep(0.5, 0.5, "a-s")

# domain or location-scale parameters do not affect 
# the skewness and the asymmetry coefficient

# BMT on [-1.783489,3.312195] with 
# left tail weight equal to 0.25 and 
# right tail weight equal to 0.75
BMTkurt(0.25, 0.75, "t w", -1.783489, 3.312195, "c-d")
BMTsteep(0.25, 0.75, "t w", -1.783489, 3.312195, "c-d")

# BMT with mean equal to 0, standard deviation equal to 1, 
# asymmetry coefficient equal to 0.5 and 
# steepness coefficient equal to 0.75
BMTkurt(0.5, 0.5, "a-s", 0, 1, "l-s")
BMTsteep(0.5, 0.5, "a-s", 0, 1, "l-s")
}
\references{
Torres-Jimenez, C. J. and Montenegro-Diaz, A. M. (2017, September), 
  \emph{An alternative to continuous univariate distributions supported on a 
  bounded interval: The BMT distribution}. ArXiv e-prints. \url{https://arxiv.org/abs/1709.05534}.
  
  Torres-Jimenez, C. J. (2018), \emph{The BMT Item Response Theory model: A 
  new skewed distribution family with bounded domain and an IRT model based 
  on it}, PhD thesis, Doctorado en ciencias - Estadistica, Universidad 
  Nacional de Colombia, Sede Bogota.
}
\seealso{
\code{\link{BMTcentral}}, \code{\link{BMTdispersion}}, 
  \code{\link{BMTskewness}}, \code{\link{BMTmoments}} for other descriptive 
  measures or moments.
}
\author{
Camilo Jose Torres-Jimenez [aut,cre] \email{cjtorresj@unal.edu.co}
}
