% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concorscano.R
\name{concorscano}
\alias{concorscano}
\title{simultaneous concorgmcano}
\usage{
concorscano(x, px, y, py, r)
}
\arguments{
\item{x}{are the \code{n} times \code{p} and \code{n} times \code{q} matrices of \code{p} and \code{q} centered column}

\item{px}{A row vector which contains the numbers pi, i=1,...,kx, of the kx subsets xi of x : sum(pi)=sum(px)=p. px is the partition vector of x}

\item{y}{See \code{x}}

\item{py}{The partition vector of y. A row vector containing the numbers \code{qi} for \code{i = 1,...,ky} of the \code{ky} subsets \code{yi} of \code{y : sum(qi)=sum(py)=q}.}

\item{r}{The number of wanted successive solutions rmax <= min(min(px),min(py),n)}
}
\value{
A \code{list} with following components:
\item{cx}{a \code{n} times \code{r} matrix of the r canonical components of x}
\item{cy}{a \code{n.ky} times \code{r} matrix. The ky blocks cyi of the rows n*(i-1)+1 : n*i contain the r canonical components relative to Yi}
\item{cov2}{a \code{ky} times \code{r} matrix; each column \code{k} contains \code{ky} squared covariances \eqn{\mbox{cov}(x*u[,k],y_i*v_i[,k])^2}, the partial measures of link}
}
\description{
concorgmcano with the set of r solutions simultaneously optimized
}
\details{
This function uses the concors function
}
\examples{

x <- matrix(runif(50),10,5);y <- matrix(runif(90),10,9)
x <- scale(x);y <- scale(y)
cca <- concorscano(x,c(2,3),y,c(3,2,4),2)
cca$rho2[1,1,]

}
\references{
Hanafi & Lafosse (2001) Generalisation de la regression lineaire simple pour analyser la dependance de K ensembles de variables avec un K+1 eme.  Revue de Statistique Appliquee vol.49, n.1
}
\author{
\enc{Lafosse, R.}{R. Lafosse}
}
