% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_endpoint.R
\name{get_boundary_nested}
\alias{get_boundary_nested}
\title{Boundary values for Nested Endpoint}
\usage{
get_boundary_nested(
  H0,
  a,
  n,
  lambda,
  gamma,
  eta = NULL,
  method = "power",
  seed = NULL
)
}
\arguments{
\item{H0}{Response rate under the null , specified in the following order:
- `H0[1]`: Complete Remission (CR) rate,
- `H0[2]`: Partial Remission (PR) rate,
- `H0[3]`: No Complete Remission or Partial Remission rate, calculated as `1 - (CR + PR)`.}

\item{a}{alpha values for the beta prior (i.e. usually set to the null response rate)}

\item{n}{A numeric vector representing the additional patients enrolled at each interim analysis.
The value at index \code{i} indicates the number of new patients added at interim analysis \code{i}. 
The total sample size at interim \code{i} is the cumulative sum of the values in \code{n} up to that index. 
For example, for four interim analyses with total sample sizes of 10, 15, 20, and 30, 
the vector would be represented as \code{n = c(10, 5, 5, 10)}, where:
\itemize{
  \item 10 is the number of patients enrolled at interim 1,
  \item 5 (15 - 10) is the additional number of patients enrolled at interim 2,
  \item 5 (20 - 15) is the additional number of patients enrolled at interim 3,
  \item 10 (30 - 20) is the additional number of patients enrolled at interim 4.
}}

\item{lambda}{A vector of values for parameter `lambda` of the cut-off probability (i.e common for both efficacy and futility cut-off probability)}

\item{gamma}{A vector of values for parameter `gamma` of the cut-off probability for futility}

\item{eta}{A vector of values for parameter `eta` of the cut-off probability for efficacy}

\item{method}{type of function to be used for the cut off probability for superiority. The default is "power" type function. method=OF is an alternative for "O'Brien-Fleming"}

\item{seed}{seed number}
}
\value{
A list with the first element corresponding to futility and the second for efficacy boundaries
}
\description{
Boundary values for Nested Endpoint
}
\examples{
H0 <- c(0.15, 0.15, 0.70)
a <- H0
seed <- 123
n <- c(10, 5, 5)
method <- "power"

boundary_nested<- get_boundary_nested(H0=H0, a=a, n =n,
                     lambda = seq(0, 1, l = 11),
                     gamma  = seq(0, 1, l = 11),
                     eta    = seq(0, 3, l = 31),
                     method = method,
                    seed = seed)


}
