% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocs_exp_covar.R
\name{ocs_exp_covar}
\alias{ocs_exp_covar}
\title{Determine operating characteristics of fits from two-arm trials with an exponentially distributed time-to-event endpoint and one predictor of the intercurrent event}
\usage{
ocs_exp_covar(multiple_fits, d_params, m_params)
}
\arguments{
\item{multiple_fits}{List of model fits from \code{fit_mult_exp_covar}.}

\item{d_params}{List of data parameters as used in \code{sim_dat_one_trial_exp_covar}.}

\item{m_params}{List of model parameters as used in \code{fit_single_exp_covar}.}
}
\value{
A list of length 3, containing objects call \code{ocs}, \code{d_params}, \code{m_params}, where \code{ocs} is a \code{tibble} containing averaged parameter estimates and operating characteristics, and \code{d_params} and \code{m_params} are the objects supplied to the function.
}
\description{
Determine operating characteristics of fits from two-arm trials with an exponentially distributed time-to-event endpoint and one predictor of the intercurrent event
}
\details{
This function is used in \code{run_sim_exp_covar()}, the output of the two functions is the same.
}
\examples{
d_params_covar <- list(
  n = 1000,        
  nt = 500,       
  prob_X1 = 0.4, 
  prob_ice_X1 = 0.5, 
  prob_ice_X0 = 0.2,
  fu_max = 48*7,
  prop_cens = 0.15,       
  T0T_rate = 0.2,     
  T0N_rate = 0.2,     
  T1T_rate = 0.15,     
  T1N_rate = 0.1
 )
dat_mult_trials <- sim_dat_mult_trials_exp_covar(
  n_iter = 2,
  params = d_params_covar 
)
m_params_covar <- list(
  tg = 48,
  p = 2, 
  prior_delta = matrix(
    c(0, 5, 0, 5),
    nrow = 2, byrow = TRUE),
  prior_0N = c(1.5, 5),
  prior_1N = c(1.5, 5),
  prior_0T = c(1.5, 5),
  prior_1T = c(1.5, 5),
  t_grid =  seq(7, 7 * 48, 7) / 30,
  chains = 2,
  n_iter = 3000,
  warmup = 1500,
  cores = 2,
  open_progress = FALSE,
  show_messages = TRUE
)
\donttest{
fit_multiple <- fit_mult_exp_covar(
  dat_mult_trials = dat_mult_trials,
  params = m_params_covar,
  seed = 12
)
list_ocs <- ocs_exp_covar(
  multiple_fits = fit_multiple, 
  d_params = d_params_covar, 
  m_params = m_params_covar
)
print(list_ocs)
}

}
\seealso{
\code{\link[=ocs_exp_nocovar]{ocs_exp_nocovar()}} and \code{\link[=run_sim_exp_covar]{run_sim_exp_covar()}}.
}
