% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BRACoD.R
\name{score}
\alias{score}
\title{Score the results of BRACoD}
\usage{
score(taxon_identified, taxon_actual)
}
\arguments{
\item{taxon_identified}{a list of integers corresponding to the indicies of the taxon you identified with BRACoD}

\item{taxon_actual}{a list of integers corresponding to the indicies of the taxon that truely contribute to butyrate levels}
}
\value{
a list containing 1) the precision 2) the recall 3) the f1 metric
}
\description{
This calculate the precision, recall and F1 of your BRACoD results if you know
the ground truth, ie. if this is simulated data.
}
\examples{
\dontrun{
df_summary <- summarize_trace(trace, colnames(sim_relab))
taxon_identified <- df_summary$taxon
taxon_actual <- which(contributions != 0)

r <- score(taxon_identified, taxon_actual)

precision <- r[[1]]
recall <- r[[2]]
f1 <- r[[3]]

print(sprintf("Precision: \%.2f, Recall: \%.2f, F1: \%.2f",precision, recall, f1))
}
}
