% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcore.R
\name{bcore}
\alias{bcore}
\title{Probability Core for Binomial RDT}
\usage{
bcore(n, c, pi)
}
\arguments{
\item{n}{RDT sample size.}

\item{c}{Maximum allowable failures.}

\item{pi}{Failure probability.}
}
\value{
Core probability of passing the test given specific failure probabilities.
}
\description{
Define the summed core function inside of the integration which gets the probability of passing the test given specific failure probabilities (for binomial RDT).
}
\examples{
bcore(n = 10, c = 2, pi = 0.2)
}
\seealso{
\code{\link{boptimal_n}} for getting the optimal test sample size;
\code{\link{bconsumerrisk}} for getting the consumer's risk;
\code{\link{bIndicator}} for getting the binary indicator;
}
