% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Apolipop}
\alias{Apolipop}
\title{Level of apolipoprotein B and number of cups of coffee consumed per day for
15 adult males}
\format{
A data frame/tibble  with 15 observations on two variables
\describe{ 
\item{coffee}{number of cups of coffee per day} 
\item{apolipB}{level of apoliprotein B} 
}
}
\usage{
Apolipop
}
\description{
Data used in Examples 9.2 and 9.9
}
\examples{

plot(apolipB ~ coffee, data = Apolipop)
linmod <- lm(apolipB ~ coffee, data = Apolipop)
summary(linmod)
summary(linmod)$sigma
anova(linmod)
anova(linmod)[2, 3]^.5
par(mfrow = c(2, 2))
plot(linmod)
par(mfrow = c(1, 1))

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
