% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Moisture}
\alias{Moisture}
\title{Moisture content and depth of core sample for marine muds in eastern
Louisiana}
\format{
A data frame/tibble with 16 observations on four variables
\describe{ 
\item{depth}{a numeric vector} 
\item{moisture}{g of water per 100 g of dried sediment} 
\item{lnmoist}{a numeric vector}
\item{depthsq}{a numeric vector} 
}
}
\source{
Davis, J. C. (1986), \emph{Statistics and Data Analysis in Geology}, 2d. ed.,
John Wiley and Sons, New York, pp. 177, 185.
}
\usage{
Moisture
}
\description{
Data for Exercise 9.32
}
\examples{

plot(moisture ~ depth, data = Moisture)
model <- lm(moisture ~ depth, data = Moisture)
abline(model, col = "red")
plot(resid(model) ~ depth, data = Moisture)
rm(model)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
