% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Poverty}
\alias{Poverty}
\title{Percent poverty and crime rate for selected cities}
\format{
A data frame/tibble with 20 observations on four variables
\describe{ 
\item{city}{a factor with levels \code{Atlanta},
\code{Buffalo}, \code{Cincinnati}, \code{Cleveland}, \code{Dayton, O},
\code{Detroit}, \code{Flint, Mich}, \code{Fresno, C}, \code{Gary, Ind},
\code{Hartford, C}, \code{Laredo}, \code{Macon, Ga}, \code{Miami},
\code{Milwaukee}, \code{New Orleans}, \code{Newark, NJ}, \code{Rochester,NY},
\code{Shreveport}, \code{St. Louis}, and \code{Waco, Tx}} 
\item{poverty}{percent of children living in poverty} 
\item{crime}{crime rate (per 1000 people)}
\item{population}{population of city} 
}
}
\source{
Children's Defense Fund and the Bureau of Justice Statistics.
}
\usage{
Poverty
}
\description{
Data for Exercise 9.11 and 9.17
}
\examples{

plot(poverty ~ crime, data = Poverty)
model <- lm(poverty ~ crime, data = Poverty)
abline(model, col = "red")
summary(model)
rm(model)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
