% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_by.R
\name{group_by.TidySet}
\alias{group_by.TidySet}
\title{group_by TidySet}
\usage{
\method{group_by}{TidySet}(.data, ...)
}
\arguments{
\item{.data}{The TidySet object}

\item{...}{The logical predicates in terms of the variables of the sets}
}
\value{
A grouped data.frame (See The dplyr help page)
}
\description{
Use group_by to group the TidySet object. You can use activate with
group_by or with the whole data.
}
\examples{
relations <- data.frame(
    sets = c(rep("a", 5), "b", rep("a2", 5), "b2"),
    elements = rep(letters[seq_len(6)], 2),
    fuzzy = runif(12)
)
a <- tidySet(relations)
elements(a) <- cbind(elements(a),
    type = c(rep("Gene", 4), rep("lncRNA", 2))
)
group_by(a, elements)
}
\seealso{
\code{\link[dplyr:group_by]{dplyr::group_by()}} and \code{\link[=activate]{activate()}}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets}()},
\code{\link{name_sets<-}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
