% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/remove.R
\name{remove_relation}
\alias{remove_relation}
\alias{remove_relation,TidySet,characterORfactor,characterORfactor-method}
\title{Remove a relation}
\usage{
remove_relation(object, elements, sets, ...)

\S4method{remove_relation}{TidySet,characterORfactor,characterORfactor}(object, elements, sets)
}
\arguments{
\item{object}{A TidySet object}

\item{elements}{The elements of the sets.}

\item{sets}{The name of the new set.}

\item{...}{Placeholder for other arguments that could be passed to the
method. Currently not used.}
}
\value{
A \code{TidySet} object.
}
\description{
Given a TidySet removes relations between elements and sets
}
\section{Methods (by class)}{
\itemize{
\item \code{remove_relation(
  object = TidySet,
  elements = characterORfactor,
  sets = characterORfactor
)}: Removes a relation between elements and sets.

}}
\examples{
relations <- data.frame(
    sets = c(rep("A", 5), "B"),
    elements = letters[seq_len(6)],
    fuzzy = runif(6)
)
TS <- tidySet(relations)
remove_relation(TS, "A", "a")
}
\seealso{
Other remove functions: 
\code{\link{remove_element}()},
\code{\link{remove_set}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group}()},
\code{\link{group_by.TidySet}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets}()},
\code{\link{name_sets<-}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
\concept{remove functions}
