% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\name{size}
\alias{size}
\title{Size}
\usage{
size(object, ...)
}
\arguments{
\item{object}{A TidySet object.}

\item{...}{Character vector with the name of elements or sets you want to
calculate the size of.}
}
\value{
The size of the elements or sets. If there is no active slot or it
is the relations slot returns the TidySet object with a warning.
}
\description{
Calculate the size of the elements or sets, using the fuzzy values as
probabilities. First it must have active either sets or elements.
}
\examples{
rel <- data.frame(
    sets = c(rep("A", 5), "B", "C"),
    elements = c(letters[seq_len(6)], letters[6])
)
TS <- tidySet(rel)
TS <- activate(TS, "elements")
size(TS)
TS <- activate(TS, "sets")
size(TS)
# With fuzzy sets
relations <- data.frame(
    sets = c(rep("A", 5), "B", "C"),
    elements = c(letters[seq_len(6)], letters[6]),
    fuzzy = runif(7)
)
TS <- tidySet(relations)
TS <- activate(TS, "elements")
size(TS)
TS <- activate(TS, "sets")
size(TS)
}
\seealso{
A related concept \code{\link[=cardinality]{cardinality()}}. It is calculated using
\code{\link[=length_set]{length_set()}}.
}
