% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastGPfit.R
\name{GP.predict}
\alias{GP.predict}
\title{Gaussian process predictions}
\usage{
GP.predict(GP_fit, newx, CI = TRUE)
}
\arguments{
\item{GP_fit}{An output object of function \link{GP.Bayes.fit} or \link{GP.fast.Bayes.fit}. Please refer to them for details.}

\item{newx}{A matrix of real numbers as new grid points for preditions.}

\item{CI}{A logical value indicating prediction.}
}
\value{
A list object
When CI is FALSE, the object consists of three elements:
\describe{
\item{f}{Posterior predictive mean values of the curves.}
\item{x}{The grid points for prediction, i.e. "newx".}
\item{work_x}{The standardized grid points for prediction.}
}
When CI is FALSE, the object consists of four elements:
\describe{
\item{mean}{A list object for posterior predictive mean of the curve,consisting of two elements (f is a vector for the curve values; x is
  a vector or matrix for points evaluated).}
  \item{work_x}{A matrix of real numbers for the standardized grid points for the model fitting.
  It has the same dimension as "newx".}
   \item{uci}{A list object for 95\% upper bound of the predictive creditible interval
   (uci) of the curve,
  consisting of two elements (f is a vector for curve values;
   x is a vector or matrix for points evaluated).}
  \item{lci}{A list object for 95\% lower bound of the predictive creditibel interval (lci) of the curve,
  consisting of two elements (f is a vector for curve value; x is
  a vector or matrix for points evaluated).}
}
}
\description{
Gaussian process predictions
}
\examples{

set.seed(1224)
traindat = list()
traindat$x = GP.generate.grids(d=2,num_grids=30,random=TRUE)
testdat = list()
testdat$x = GP.generate.grids(d=2,num_grids=30,random=FALSE)
curve = GP.simulate.curve.fast(rbind(traindat$x,testdat$x),a=0.01,b=0.5,poly_degree=20L)
train_curve = list(f=curve$f[1:nrow(traindat$x)],x=traindat$x)
test_curve = list(f=curve$f[nrow(traindat$x)+1:nrow(testdat$x)],x=testdat$x)
traindat$f = train_curve$f + rnorm(length(train_curve$f),sd=1)
testdat$f = test_curve$f + rnorm(length(test_curve$f),sd=1)
fast_fit = GP.fast.Bayes.fit(traindat$f,traindat$x,a=0.01,b=0.5,poly_degree=20L,progress_bar = TRUE)
reg_fit = GP.Bayes.fit(traindat$f,traindat$x,a=0.01,b=0.5,poly_degree=20L,progress_bar = TRUE)
fast_pred = GP.predict(fast_fit,testdat$x,CI=TRUE)
reg_pred = GP.predict(reg_fit,testdat$x,CI=TRUE)
pmse = c(fast = mean((fast_pred$mean$f-test_curve$f)^2),
        reg = mean((reg_pred$mean$f-test_curve$f)^2))
print(pmse)
curves = list(true = test_curve,
             Bayes = reg_pred$mean,
             fast = fast_pred$mean)
GP.plot.curves(curves,main="Posterior predictive mean")

}
\author{
Jian Kang <jiankang@umich.edu>
}
