% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{Compare_Growth_Models}
\alias{Compare_Growth_Models}
\title{Compare_Growth_Models}
\usage{
Compare_Growth_Models(
  data,
  Linf = NULL,
  Linf.se = NULL,
  L0 = NULL,
  L0.se = NULL,
  k.max = NULL,
  sigma.max = NULL,
  iter = 10000,
  BurnIn = iter/2,
  n_cores = 1,
  controls = NULL,
  n.chains = 4,
  thin = 1,
  verbose = FALSE,
  stats = "LooIC"
)
}
\arguments{
\item{data}{A data.frame that contains columns named 'Age' and "Length'. The function can
detect columns with similar names. If age and length columns cannot be determined then
an error will occur. The dataset can have additional columns which will be ignored by
the function}

\item{Linf}{The prior for asymptotic length. Must be in the same unit (i.e. cm or mm) as the data.
This should be based off of maximum size for the species.}

\item{Linf.se}{The prior for normally distributed standard error around
asymptotic length. Must be in the same unit (i.e. cm or mm) as the data. Cannot be zero.}

\item{L0}{The prior for length-at-birth. Must be in the same unit (i.e. cm or mm) as the data.
This should be based off of minimum size for the species.}

\item{L0.se}{The prior for normally distributed standard error around
length-at-birth. Must be in the same unit (i.e. cm or mm) as the data. Cannot be zero.}

\item{k.max}{The maximum value to consider for the growth completion parameter 'k'. In
the Gompertz and Logistic models, this parameter is often notated as 'g' instead of 'k'.}

\item{sigma.max}{The maximum value to consider for sigma. This is the variance around the
length-at-age residuals.}

\item{iter}{How many MCMC iterations should be run? Default is 10000 but fewer can be useful to
avoid longer run times when testing code or data}

\item{BurnIn}{The number of iterations at the beginning of each chain to discard ('Burn in') to
avoid biased values from starting values that do not resemble the target distribution.
Default is iter/2.}

\item{n_cores}{The number of cores to be used for parallel processing. It should be 1 core less than the
maximum number available.}

\item{controls}{A named list of parameters to control the rstan models behaviour.}

\item{n.chains}{Number of MCMC chains to be run. Default is 4.}

\item{thin}{The thinning of the MCMC simulations. Default is 1 which means no thinning occurs.
Thinning is generally only necessary for complicated models as it increases run time.}

\item{verbose}{TRUE or FALSE: flag indicating whether to print intermediate output from Stan on the console,
which might be helpful for model debugging.}

\item{stats}{Which statistics should be returned: LooIC, WAIC or both (both will return a list)}
}
\value{
A dataframe with the requested stats
}
\description{
Conduct growth model selection using 'Leave One Out' (LOO) cross validation analysis and
    Widely Applicable Information Criterion (WAIC)for three growth models:
    (von Bertalanffy, Gompertz and Logistic) using the same prior parameters for each.
}
\examples{
\donttest{
# load example data
data("example_data")
## Biological info - lengths in mm
max_size <- 440
max_size_se <- 5
birth_size <- 0
birth_size_se <- 0.001 # an se cannot be zero

# Use the function to compare growth models with LooIC
Looic_example_results <- Compare_Growth_Models(data = example_data,
                                               stats = "LooIC",
                                               iter = 10000,
                                               n.chains = 4,
                                               BurnIn = 1000,
                                               thin = 1,
                                               n_cores = 1,
                                               Linf = max_size,
                                               Linf.se = max_size_se,
                                               L0 = birth_size,
                                               L0.se = birth_size_se,
                                               verbose = TRUE,
                                               sigma.max = 100,
                                               k.max = 1)
}
}
