% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdTOST.R
\name{ssdTOST}
\alias{ssdTOST}
\title{Sample size determination for replication success based on
    TOST equivalence}
\usage{
ssdTOST(level, dprior, power, margin, searchInt = c(0, 2))
}
\arguments{
\item{level}{Significance level for the TOST p-value}

\item{dprior}{Design prior object}

\item{power}{Desired probability of replication success}

\item{margin}{The equivalence margin > 0 for the equivalence region around
zero that defines a region of practically irrelevant effect sizes}

\item{searchInt}{Interval for numerical search over replication standard
errors}
}
\value{
Returns an object of class \code{"ssdRS"}. See \code{\link{ssd}} for
    details.
}
\description{
This function computes the standard error required to achieve
    replication success with a certain probability and based on establishing
    the absence of a practically relevant effect size with the Two One-Sided
    Tests (TOST) procedure in the replication study.
}
\examples{
## specify design prior
to1 <- 0.05
so1 <- 0.05
dprior <- designPrior(to = to1, so = so1, tau = 0.05)
ssdTOST(level = 0.05, dprior = dprior, power = 0.9, margin = 0.3)

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}

Anderson, S. F. and Maxwell, S. E. (2016). There's more than one way to
conduct a replication study: Beyond statistical significance. Psychological
Methods, 21(1), 1-12. \doi{10.1037/met0000051}
}
\author{
Samuel Pawel
}
