% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/successRegion.R
\name{successRegion}
\alias{successRegion}
\title{Success region for replication effect estimate}
\usage{
successRegion(intervals)
}
\arguments{
\item{intervals}{A 2xN matrix containing N disjoint intervals, the first
column containing the lower and the second column containing the upper
limits}
}
\value{
Returns an object of class \code{"successRegion"} which is a matrix
    containing the success intervals sorted in ascending order
}
\description{
Creates a success region object which can then be used for
    computing the probability of replication success with \code{\link{pors}}.
}
\examples{
successRegion(intervals = rbind(c(1.96, Inf), c(-Inf, -1.96)))
successRegion(intervals = cbind(1.96, Inf))

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}
}
\seealso{
\code{\link{pors}}, \code{\link{ssd}}
}
\author{
Samuel Pawel
}
