% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{numerical_stability_exp}
\alias{numerical_stability_exp}
\title{Numerical stability (exponential penalty)}
\usage{
numerical_stability_exp(W, a = 1000, b = 10)
}
\arguments{
\item{W}{Posterior matrix (\eqn{T \times K}).}

\item{a}{Sensitivity for row-sum deviation (default \code{1000}).}

\item{b}{Sensitivity for negative counts (default \code{10}).}
}
\value{
Scalar numerical stability score in \eqn{[0,1]}.
}
\description{
Penalizes numerical issues in \eqn{W}: (i) deviation of each row sum from 1,
measured by the mean absolute deviation, and (ii) count of negative entries.
The score is \eqn{\exp(-(a\,\mathrm{msd} + b\,\#\mathrm{neg}))}.
}
\examples{
W <- matrix(runif(20), 5); W <- W/rowSums(W)
numerical_stability_exp(W)

}
