% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood.R
\name{spread_likelihood}
\alias{spread_likelihood}
\title{Spread a likelihood vector across time with a chosen temporal pattern}
\usage{
spread_likelihood(
  L,
  T_periods,
  pattern = c("constant", "recent", "linear", "bell")
)
}
\arguments{
\item{L}{Numeric vector (length \eqn{K}); sectoral likelihood. It is normalized
internally to sum to 1 before spreading.}

\item{T_periods}{Integer; number of time periods \eqn{T}.}

\item{pattern}{Temporal pattern for the weights across time; one of
\code{"constant"}, \code{"recent"}, \code{"linear"}, \code{"bell"}.}
}
\value{
Numeric matrix \eqn{T \times K}; each row sums to 1.
}
\description{
Expands a sectoral likelihood \eqn{L} (length \eqn{K}) into a \eqn{T \times K}
matrix by applying a temporal weight profile and then row-normalizing to the
simplex.
}
\details{
Given \eqn{L} and a non-negative time-weight vector \eqn{w_t}, the function
replicates \eqn{L} across rows and applies \eqn{w} elementwise, then
\emph{row-normalizes} using \code{row_norm1()}:
\deqn{LT_{t,k} \propto w_t \cdot L_k, \qquad \sum_k LT_{t,k} = 1 \ \forall t.}

Patterns:
\itemize{
  \item \code{"constant"}: \eqn{w_t = 1}.
  \item \code{"recent"}: linearly increasing in \eqn{t} (more weight to later periods).
  \item \code{"linear"}: affine ramp from first to last period.
  \item \code{"bell"}: symmetric bell-shaped profile centered at \eqn{T/2}.
}
}
\examples{
set.seed(1)
K <- 5; T <- 8
L <- runif(K); L <- L / sum(L)
LT <- spread_likelihood(L, T, "recent")
stopifnot(nrow(LT) == T, ncol(LT) == K, all(abs(rowSums(LT) - 1) < 1e-12))

}
\seealso{
\code{\link{compute_L_from_P}}, \code{\link{bayesian_disaggregate}}
}
