% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCorrelationDensity.r
\name{correlationPlot}
\alias{correlationPlot}
\title{Flexible function to create correlation density plots}
\usage{
correlationPlot(
  mat,
  density = "smooth",
  thin = "auto",
  method = "pearson",
  whichParameters = NULL,
  scaleCorText = T,
  ...
)
}
\arguments{
\item{mat}{object of class "bayesianOutput" or a matrix or data frame of variables}

\item{density}{type of plot to do. Either "smooth" (default), "corellipseCor", or "ellipse"}

\item{thin}{thinning of the matrix to make things faster. Default is to thin to 5000}

\item{method}{method for calculating correlations. Possible choices are "pearson" (default), "kendall" and "spearman"}

\item{whichParameters}{indices of parameters that should be plotted}

\item{scaleCorText}{should the text to display correlation be scaled to the strength of the correlation}

\item{...}{additional parameters to pass on to the \code{\link{getSample}}, for example parametersOnly =F, or start = 1000}
}
\description{
Flexible function to create correlation density plots
}
\examples{
## Generate a test likelihood function. 
ll <- generateTestDensityMultiNormal(sigma = "no correlation")

## Create a BayesianSetup object from the likelihood 
## is the recommended way of using the runMCMC() function.
bayesianSetup <- createBayesianSetup(likelihood = ll, lower = rep(-10, 3), upper = rep(10, 3))

## Finally we can run the sampler and have a look
settings = list(iterations = 1000)
out <- runMCMC(bayesianSetup = bayesianSetup, sampler = "DEzs", settings = settings)

## Correlation density plots:
correlationPlot(out)

## additional parameters can be passed to getSample (see ?getSample for further information)
## e.g. to select which parameters to show or thinning (faster plot)
correlationPlot(out, scaleCorText = FALSE, thin = 100, start = 200, whichParameters = c(1,2))

## text to display correlation will be not scaled to the strength of the correlation
correlationPlot(out, scaleCorText = FALSE) 

## We can also switch the method for calculating correllations
correlationPlot(out, scaleCorText = FALSE, method = "spearman")


}
\references{
The code for the correlation density plot originates from Hartig, F.; Dislich, C.; Wiegand, T. & Huth, A. (2014) Technical Note: Approximate Bayesian parameterization of a process-based tropical forest model. Biogeosciences, 11, 1261-1272.
}
\seealso{
\code{\link{marginalPlot}} \cr
\code{\link{plotTimeSeries}} \cr
\code{\link{tracePlot}} \cr
}
\author{
Florian Hartig
}
