% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrjm.R
\name{qrjm}
\alias{qrjm}
\title{\code{qrjm} fits quantile regression joint model}
\usage{
qrjm(
  formFixed,
  formRandom,
  formGroup,
  formSurv,
  survMod = "weibull",
  param = "value",
  timeVar,
  data,
  tau,
  RE_ind = FALSE,
  n.chains = 3,
  n.iter = 10000,
  n.burnin = 5000,
  n.thin = 1,
  n.adapt = 5000,
  precision = 10,
  C = 1000,
  save_jagsUI = TRUE,
  save_va = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{formFixed}{formula for fixed part of longitudinal submodel with response variable}

\item{formRandom}{formula for random part of longitudinal submodel without response variable}

\item{formGroup}{formula specifying the cluster variable (e.g. = ~ subject)}

\item{formSurv}{survival formula as formula in survival package for latency submodel}

\item{survMod}{specifying the baseline risk function for Cox proportional hazard model (only "weibull" is available until now)}

\item{param}{shared association including in joint modeling: the classical shared random effects or the current value denoting by "sharedRE" (default) or "value", respectively.}

\item{timeVar}{string specify the names of time variable (time of repeated measurements)}

\item{data}{dataset of observed variables}

\item{tau}{the quantile(s) to be estimated. This must be a number between 0 and 1, otherwise the execution is stopped. If more than one quantile is specified, rounding off to the 4th decimal must give non–duplicated values of \code{tau}, otherwise the execution is stopped.}

\item{RE_ind}{Boolean denoting if the random effects are assumed independent ; default is \code{FALSE}}

\item{n.chains}{the number of parallel chains for the model; default is 1.}

\item{n.iter}{integer specifying the total number of iterations; default is 10000}

\item{n.burnin}{integer specifying how many of \code{n.iter} to discard as burn-in ; default is 5000}

\item{n.thin}{integer specifying the thinning of the chains; default is 1}

\item{n.adapt}{integer specifying the number of iterations to use for adaptation; default is 5000}

\item{precision}{variance by default for vague prior distribution}

\item{C}{value used in the zero trick; default is 1000.}

\item{save_jagsUI}{If \code{TRUE} (by default), the output of \code{jagsUI} package is returned by the function}

\item{save_va}{If \code{TRUE} (is \code{FALSE} by default), the draws of auxiliary variable W is returned by the function}

\item{parallel}{see \code{jagsUI::jags()} function}
}
\value{
A \code{Bqrjm} object is a list with the following elements:
\describe{
\item{\code{mean}}{list of posterior mean for each parameter}
\item{\code{median}}{list of posterior median for each parameter}
\item{\code{modes}}{list of posterior mode for each parameter}
\item{\code{StErr}}{list of standard error for each parameter}
\item{\code{StDev}}{list of standard deviation for each parameter}
\item{\code{ICs}}{list of the credibility interval at 0.95 for each parameters excepted for covariance parameters in covariance matrix of random effects. Otherwise, use save_jagsUI=TRUE to have the associated quantiles.}
\item{\code{data}}{data included in argument}
\item{\code{sims.list}}{list of the MCMC chains of the parameters and random effects}
\item{\code{control}}{list of arguments giving details about the estimation}
\item{\code{random_effect}}{list for each quantile including both posterior mean and posterior standard deviation of subject-specific random effects}
\item{\code{out_jagsUI}}{only if \code{save_jagsUI=TRUE} in argument: list including posterior mean, median, quantiles (2.5\%, 25\%, 50\%, 75\%, 97.5\%), standart deviation for each parameter and each random effect.
Moreover, this list also returns the MCMC draws, the Gelman and Rubin diagnostics (see output of jagsUI objects)}
}
}
\description{
Function using 'JAGS' software via \code{jagsUI} package to estimate the quantile regression joint model assuming asymmetric Laplace distribution for residual error.
Joint modeling concerns longitudinal data and time-to-event
}
\examples{

\donttest{
#---- load data
data(dataLong)

#---- Fit quantile regression joint model for the first quartile
qrjm_75 <- qrjm(formFixed = y ~ visit,
               formRandom = ~ visit,
               formGroup = ~ ID,
               formSurv = Surv(time, event) ~ X1 + X2,
               survMod = "weibull",
               param = "value",
               timeVar= "visit",
               data = dataLong,
               tau = 0.75)

#---- Visualize the trace for beta parameters
jagsUI::traceplot(qrjm_75$out_jagsUI, parameters = "beta")

#---- Get the estimated coefficients: posterior means
qrjm_75$mean

#---- Summary of output
summary(qrjm_75)
}

}
\references{
Ming Yang, Sheng Luo, and Stacia DeSantis (2019).
\emph{Bayesian quantile regression joint models: Inference and dynamic predictions}.
Statistical Methods in Medical Research, 28(8):2524-2537. doi: 10.1177/0962280218784757.
}
\author{
Antoine Barbieri
}
