/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.util.Taxon;
import dr.math.MathUtils;

public interface SlidableTree {
    public NodeRef getSlidableRoot();

    public int getSlidableNodeCount();

    public Taxon getSlidableNodeTaxon(NodeRef var1);

    public double getSlidableNodeHeight(NodeRef var1);

    public void setSlidableNodeHeight(NodeRef var1, double var2);

    public boolean isExternalSlidable(NodeRef var1);

    public NodeRef getSlidableChild(NodeRef var1, int var2);

    public void replaceSlidableChildren(NodeRef var1, NodeRef var2, NodeRef var3);

    public void replaceSlidableRoot(NodeRef var1);

    public static class Utils {
        public static NodeRef[] mnlCanonical(SlidableTree slidableTree) {
            int n = slidableTree.getSlidableNodeCount();
            NodeRef[] nodeRefArray = new NodeRef[n];
            Utils.mnlCanonicalSub(slidableTree, slidableTree.getSlidableRoot(), 0, nodeRefArray);
            return nodeRefArray;
        }

        public static void mnlReconstruct(SlidableTree slidableTree, NodeRef[] nodeRefArray) {
            NodeRef nodeRef = Utils.mnlReconstructSub(slidableTree, 0, (nodeRefArray.length - 1) / 2, nodeRefArray);
            slidableTree.replaceSlidableRoot(nodeRef);
        }

        private static int mnlCanonicalSub(SlidableTree slidableTree, NodeRef nodeRef, int n, NodeRef[] nodeRefArray) {
            if (slidableTree.isExternalSlidable(nodeRef)) {
                nodeRefArray[n] = nodeRef;
                assert ((n & 1) == 0);
                return ++n;
            }
            boolean bl = MathUtils.nextBoolean();
            n = Utils.mnlCanonicalSub(slidableTree, slidableTree.getSlidableChild(nodeRef, bl ? 1 : 0), n, nodeRefArray);
            nodeRefArray[n] = nodeRef;
            assert ((n & 1) == 1);
            ++n;
            n = Utils.mnlCanonicalSub(slidableTree, slidableTree.getSlidableChild(nodeRef, bl ? 0 : 1), n, nodeRefArray);
            return n;
        }

        private static NodeRef mnlReconstructSub(SlidableTree slidableTree, int n, int n2, NodeRef[] nodeRefArray) {
            if (n == n2) {
                return nodeRefArray[2 * n];
            }
            int n3 = Utils.highestNode(slidableTree, nodeRefArray, n, n2);
            NodeRef nodeRef = nodeRefArray[2 * n3 + 1];
            NodeRef nodeRef2 = Utils.mnlReconstructSub(slidableTree, n, n3, nodeRefArray);
            NodeRef nodeRef3 = Utils.mnlReconstructSub(slidableTree, n3 + 1, n2, nodeRefArray);
            slidableTree.replaceSlidableChildren(nodeRef, nodeRef2, nodeRef3);
            return nodeRef;
        }

        private static int highestNode(SlidableTree slidableTree, NodeRef[] nodeRefArray, int n, int n2) {
            int n3 = -1;
            double d = -1.0;
            for (int i = n; i < n2; ++i) {
                double d2 = slidableTree.getSlidableNodeHeight(nodeRefArray[2 * i + 1]);
                if (!(d2 > d)) continue;
                d = d2;
                n3 = i;
            }
            return n3;
        }
    }
}

