% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btrf.R
\name{btrf}
\alias{btrf}
\title{Generalized inverse-logit transform}
\usage{
btrf(xt, xl, xu)
}
\arguments{
\item{xt}{a numeric vector}

\item{xl}{a numeric vector of same length as x}

\item{xu}{a numeric vector of same length as x, and xu > xl}
}
\value{
returns the inverse-logit transform (numeric) of xt
}
\description{
maps real line onto open interval (xl, xu) using the transform y = (exp(xt)
* xu + xl)/(1.+exp(xt)) where xt is a numeric vector with -Inf < xt < Inf
}
\seealso{
\code{\link{ftrf}}
}
\author{
E. Georg Luebeck (FHCRC)
}
\keyword{misc}
\keyword{optimize}
