% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeRNA.R
\name{describeRNA}
\alias{describeRNA}
\title{describeRNA}
\usage{
describeRNA(
  counts,
  biotypes,
  groups,
  report = FALSE,
  verbose = FALSE,
  filter = 1
)
}
\arguments{
\item{counts}{data.frame where you have gene counts}

\item{biotypes}{data.frame where you have a gene_biotype column}

\item{groups}{factor with groups and samples (see Examples)}

\item{report}{if TRUE will generate a .pdf file in /tmp/ folder ('wordcloud' and 'RColorBrewer' are necessary)}

\item{verbose}{if TRUE will print your result in your console ('knitr' is necessary)}

\item{filter}{Your threshold (see edgeR::filterByExpr)}
}
\description{
This function provide filterByExpr with two customized options. See 'Arguments'. Different strategies can be useful either if you are trying to compare different approaches of normalization or if you want to analyze a particular biotype where a different variation of expression is expected under certain conditions. A BioInsight data frame will return with your new count matrix where you can proceed with your Differential Expression Analysis.
}
\details{
For filter you may want to use "1" if you want the default option from filterByExpr. If 2 "Slightly" above the default will be applied. If "3" A more restrictive option will be applied.
}
\note{
You can use trace(describeRNA, edit=T) to set different values as threshold for "filter" option.
}
\examples{
counts = system.file("extdata", "count_matrix.tsv", package="BioInsight")
counts = read.table(counts, row.names=1, header=TRUE)
biotypes = system.file("extdata", "Rattus_Norvegicus_biomart.tsv", package="BioInsight")
biotypes = read.table(biotypes, row.names=1, header=TRUE)

groups = rep(as.factor(c("1","2")), each=5)

describeRNA(counts=counts,
            biotypes=biotypes,
            groups=groups,
            filter=2)
}
\references{
Robinson MD, McCarthy DJ, Smyth GK. edgeR: a Bioconductor package for differential expression analysis of digital gene expression data. Bioinformatics. 2010;26(1):139-140. doi:10.1093/bioinformatics/btp616
}
