% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_values_excel.R
\name{metvalgrpxl}
\alias{metvalgrpxl}
\title{Metric values Groups to Excel}
\usage{
metvalgrpxl(
  fun.DF.MetVal,
  fun.DF.xlMetNames = NULL,
  fun.Community,
  fun.MetVal.Col2Keep = c("SAMPLEID", "INDEX_NAME", "INDEX_CLASS"),
  fun.xlGrpCol = "Sort_Group",
  file.out = NULL
)
}
\arguments{
\item{fun.DF.MetVal}{Data frame of metric values.}

\item{fun.DF.xlMetNames}{Data frame of metric names and groups.
Default (NULL) will use the verion of MetricNames.xlsx that is in the
BioMonTools package.}

\item{fun.Community}{Community name of calculated metric values
(bugs, fish, or algae)}

\item{fun.MetVal.Col2Keep}{Column names in metric values to keep.
Default = c("SAMPLEID", "INDEX_NAME", "INDEX_CLASS")}

\item{fun.xlGrpCol}{Column name from Excel metric names to use for Groupings.
Default = Sort_Group}

\item{file.out}{Output file name.  Default (NULL) will generate a file name
based on the data and time (e.g., MetricValuesGroups_bugs_20220201.xlsx)}
}
\value{
Saves Excel file with metrics grouped by worksheet
}
\description{
The output of metric.values() is saved to Excel with different
groups of metrics on different worksheets.
}
\details{
This function will save the output of metric.values() into groups
by worksheet as defined by the user.

The Excel file MetricNames.xlsx provided in the extdata folder has a column
named 'Groups' that can be used as default groupings. If no groupings are
provided (the default) all metrics are saved to a single worksheet.  Within
each group the 'sort_order' is used to sort the metrics.  If this column
is blank then the metrics are sorted in the order they appear in the
output from metric.values() (i.e., in fun.DF).

The MetricNames data frame must include the following fields:

* Metric_Name

* Community

* Sort_Group (user defined)
}
\examples{
# Example 1, bugs
## Community
comm <- "bugs"
## Calculate Metrics
df_metval <- metric.values(BioMonTools::data_benthos_PacNW, comm)
## Metric Names and Groups
df_metnames <- readxl::read_excel(system.file("extdata/MetricNames.xlsx",
                                              package="BioMonTools"),
                                  guess_max = 10^6,
                                  sheet = "MetricMetadata",
                                  skip = 4)
## Columns to Keep
col2keep <- c("SAMPLEID", "INDEX_NAME", "INDEX_CLASS")
## Grouping Column
col_Grp <- "Sort_Group"
## File Name
file_out <- file.path(tempdir(), paste0("MetValGrps_", comm, ".xlsx"))
## Run Function
metvalgrpxl(df_metval, df_metnames, comm, col2keep, col_Grp, file_out)

}
