% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory.R
\docType{class}
\name{trajectory}
\alias{trajectory}
\title{Trajectory Class}
\usage{
trajectory(x, y, delta_time = 1)
}
\arguments{
\item{x}{Numeric vector with the 'x' coordinates of the trajectory.}

\item{y}{Numeric vector with the 'y' coordinates of the trajectory.}

\item{delta_time}{Control variable with a default value of 1.}
}
\description{
A class representing a trajectory of an object over time, including the `x` and `y` coordinates
of the object's centroids across frames. It provides methods to manipulate and analyze the 
trajectory, such as calculating the length, summarizing the trajectory, printing the summary,
and plotting the trajectory.
}
\details{
The `Trajectory` class stores the coordinates of an object across multiple frames. The class
provides methods to compute various aspects of the trajectory, such as its length and summary 
statistics, as well as visualizations. It can also be used to manipulate the trajectory, 
such as combining it with another trajectory using the `|` operator.
}
