% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_EstimateCompactness.R
\name{BP_EstimateCompactness}
\alias{BP_EstimateCompactness}
\title{Estimation of the compactness of a bone section}
\usage{
BP_EstimateCompactness(
  bone,
  center = "ontogenetic",
  partial = FALSE,
  NbRemoveEdgePartial = 1,
  cut.angle = 60,
  cut.distance = 100,
  NbRemoveDistanceExterior = 1,
  rotation.angle = 0,
  analysis = 1,
  method = "Fast",
  show.plot = TRUE,
  cut.max = 360
)
}
\arguments{
\item{bone}{The bone image to be used}

\item{center}{Which center to be used: user, mineralized, unmineralized, section, ontogenetic}

\item{partial}{Is the section partial?}

\item{NbRemoveEdgePartial}{How many radial section to remove at the edge of partial section?}

\item{cut.angle}{Number of angles}

\item{cut.distance}{Number of distances}

\item{NbRemoveDistanceExterior}{How many exterior sectors should be removed from analysis?}

\item{rotation.angle}{The angle of rotation for analysis}

\item{analysis}{The name or rank of analysis}

\item{method}{Can be Fast, Accurate, FastConvex, or AccurateConvex}

\item{show.plot}{should plot is shown ?}

\item{cut.max}{The number of slices for the internal estimation}
}
\value{
The orignial bone object with a new attribute for compactness
}
\description{
Estimation of the compactness of a bone section.\cr
The reference for radial estimation of compactness is the trigonometric circle for rotation.angle=0 in
BP_EstimateCompactness():\cr
\itemize{
\item The top of the section is located at -pi/2.\cr
\item The left of the section is located at -pi and +pi.\cr
\item The bottom of the section is located at pi/2.\cr
\item The right of the section is 0.\cr
If rotation.angle is different from 0, the value of rotation.angle is added to the angle modulo 2.pi.\cr
The method Fast works well with the convex bone section while if the section is concave, Accurate is slower but works well in all circonstances.\cr
Fast method is maintained here only for compatibility with versions <3.1 of BoneProfileR.\cr
If the section is concave, the methods FastConvex and AccurateConvex return a minimum convex section.\cr
If the center has been automatically detected, the method parameter is ignored because it has already
been used with the function BP_DetectCenters().
}
}
\details{
BP_EstimateCompactness estimates the compactness of a bone section
}
\examples{
\dontrun{
# Not run:
library(BoneProfileR)
 bone <- BP_OpenImage()
 # or 
path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 bone <- BP_DetectBackground(bone=bone)
 bone <- BP_DetectForeground(bone=bone)
 bone <- BP_DetectCenters(bone=bone)
 bone <- BP_EstimateCompactness(bone)
 plot(bone, type="original", show.grid=FALSE)
 plot(bone, type="mineralized", show.grid=FALSE)
 plot(bone, type="unmineralized", show.grid=FALSE)
 plot(bone, type="section", show.grid=FALSE)
 plot(bone, type="original", show.grid=TRUE)
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitBayesianPeriodicCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLPeriodicCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
