% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_brazil_rate_name.R
\name{get_brazil_rate_name}
\alias{get_brazil_rate_name}
\title{Get Specific Brazilian Economic Rate by Name}
\usage{
get_brazil_rate_name(rate_name)
}
\arguments{
\item{rate_name}{A character string indicating the rate to retrieve. Valid examples include
\code{"CDI"}, \code{"Selic"}, or \code{"IPCA"}. Case-insensitive.}
}
\value{
A tibble with two columns: \code{nome} (name of rate) and \code{valor} (numeric value).
}
\description{
This function retrieves the value of a specific Brazilian economic rate (e.g., "CDI", "Selic", "IPCA")
from the BrasilAPI endpoint.
}
\examples{
\dontrun{
get_brazil_rate_name("CDI")
get_brazil_rate_name("Selic")
get_brazil_rate_name("IPCA")
}

}
\seealso{
\code{\link{get_brazil_rates}} to retrieve all rates at once.
}
