% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climatological_normal_CWS.R
\name{download_climate_normals}
\alias{download_climate_normals}
\title{Download climatological normals from Conventional weather stations (CWS) of Inmet}
\usage{
download_climate_normals(variable, range_time)
}
\arguments{
\item{variable}{The variables available to download. The available variables are: rainfall_norm, t2m_norm, rh_norm, ws_norm and etp_norm.}

\item{range_time}{The range of time which the climatological normals were computed. The available range of time is: "1991-2020".}
}
\value{
Returns a data.frame with climatological normal required.
}
\description{
This function will download the climatological normals from CWS stations available in Inmet site.
}
\examples{
\dontrun{
df <- download_climate_normals(
  variable = "rainfall_norm",
  range_time = "1991-2020"
)
}
}
\author{
Roberto Filgueiras
}
