% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-data.R
\docType{data}
\name{profil}
\alias{profil}
\title{N-of-1 trials with On-demand Sildenafil as a Treatment for Raynaud Phenomenon}
\format{
An object of class \code{data.frame} with 2306 rows and 9 columns.
}
\usage{
data(profil, package = "BuyseTest")
}
\description{
Data from the Profil trial, a multiple crossover study where 38 patients had repeat blocks.
Each block lasted 3 weeks and corresponded to a sequence of all three treatments (placebo, sildenafil 40mg, or sildenafil 80mg), each treatment being allocated during 1 week.
The principal outcome were Raynaud Condition Score (RCS) and the frequency and cumulative duration of attacks over 24 hours.

\itemize{
\item \code{id}: study participant.
\item \code{age}: age in years, between 18 and 74 years.
\item \code{male}: indicator of whether the participant was a male. 
\item \code{period}: number of the block for a given patient. From 1 to 5.
\item \code{time}: number of days since inclusion.
\item \code{treatment}: treatment allocated during the period (placebo, lowDose, highDose)
\item \code{rcs}: RCS score, ranging from 0 to 10.
\item \code{number}: daily number of attack, ranging from 0 to 9.
\item \code{duration}: cumulative daily duration of attacks in minutes, between 0 and 755 minutes.
}
}
\references{
Matthieu Roustit, Joris Giai, Olivier Gaget, et al. On-Demand Sildenafil as a Treatment for Raynaud Phenomenon: A Series of n-of-1 Trials. Ann Intern Med.2018;169:694-703. [Epub 30 October 2018]. doi:10.7326/M18-0517
}
\author{
Brice Ozenne took a subset of the columns from the original dataset (available at \url{https://datadryad.org/dataset/doi:10.5061/dryad.c670tq2})
and translated their names into english.
}
\keyword{datasets}
