% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CADF_to_annualhalfing_model.R
\name{annualhalfingmodel}
\alias{annualhalfingmodel}
\title{Annual Halfing Model}
\usage{
annualhalfingmodel(cadf.data, starting.values)
}
\arguments{
\item{cadf.data}{cadf-formatted dataset}

\item{starting.values}{parameter starting values for model}
}
\value{
Returns model parameters
}
\description{
A recency-frequency model used in non-contractual situations.
Model assumptions:
1.) Increasing recency leads to higher probability of quitting.
2.) Frequency is related to exponential learning curves
Reference: Segmentation and Lifetime Value Modeling in SAS (Edward Malthouse)
}
\examples{
dta <- lapply(CADF::cadf.data.sample, function(x) tail(x$data, 1))
dta <- do.call(rbind, dta)
starting.values <- c(.5,.9,.2,-.9)
annualhalfingmodel(cadf.data.sample, starting.values)
}
