% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_climate.R
\name{simulate_climate_series}
\alias{simulate_climate_series}
\title{Simulate monthly climate time series for stations}
\usage{
simulate_climate_series(
  stations,
  start_year = 1981,
  end_year = 2020,
  seed = NULL
)
}
\arguments{
\item{stations}{data.frame from create_stations() (Station, LON, LAT)}

\item{start_year}{integer (e.g., 1981)}

\item{end_year}{integer (e.g., 2020)}

\item{seed}{optional numeric seed}
}
\value{
A tidy data.frame with one row per station × month containing:
Station, LON, LAT, Year, Month, Date, Avg.Tn, Avg.Tx, Sum.Rf, Avg.Rf
}
\description{
Simulate monthly Tmin, Tmax, monthly total rainfall (Sum.Rf) and mean daily rainfall (Avg.Rf)
for each station across a year range.
}
\details{
This function simulates synthetic time-series climate data based on...
}
\examples{
st <- create_stations(n = 3, seed = 1)
sim <- simulate_climate_series(st, 1981, 1982, seed = 42)
head(sim)
}
\seealso{
\code{\link[=write_station_csv]{write_station_csv()}}, \code{\link[=write_station_netcdf]{write_station_netcdf()}}
}
\concept{IO Functions}
