% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDVI.R
\name{CDVI}
\alias{CDVI}
\title{CDVI}
\usage{
CDVI(data, verbose = TRUE)
}
\arguments{
\item{data}{Name of the data taken for the study}

\item{verbose}{Logical. If TRUE, the function prints detailed information about its progress. Default is FALSE.}
}
\value{
CV, CDVI
}
\description{
Cuddy-Della Valle Index for Capturing the Instability in Time Series Data.
}
\examples{
{
library(CDVI)
Prices <- runif(15, min = 800, max = 1200)
data <- data.frame(Prices)
CDVI(data = data$Prices)
}

}
\references{
1. Shankar, S. V., Chandel, A., Gupta, R. K., Sharma, S., Chand, H., Kumar, R., ... & Gowsar, S. N. (2023). Corrigendum: Exploring the dynamics of arrivals and prices volatility in onion (Allium cepa) using advanced time series techniques. Frontiers in Sustainable Food Systems, 7, 1290515. DOI: 10.3389/fsufs.2023.1208898
}
