% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFM.R
\name{censored_factor_models}
\alias{censored_factor_models}
\title{Basic censored-factor data simulator}
\usage{
censored_factor_models(
  n,
  p,
  m,
  distribution = c("normal", "t", "logistic"),
  df = NULL,
  seed = NULL
)
}
\arguments{
\item{n}{Sample size (> 0).}

\item{p}{Number of observed variables (> 0).}

\item{m}{Number of latent factors (< p).}

\item{distribution}{Error distribution: "normal" (default), "t", "logistic".}

\item{df}{Degrees of freedom when distribution = "t".}

\item{seed}{Optional random seed.}
}
\value{
A list with components:
  \item{data}{numeric n × p matrix of observations}
  \item{loadings}{p × m factor loadings matrix}
  \item{uniqueness}{p × p diagonal uniqueness matrix}
  \item{KMO}{KMO measure of sampling adequacy}
  \item{Bartlett_p}{p-value of Bartlett's test}
  \item{distribution}{error distribution used}
  \item{seed}{random seed}
}
\description{
Generates multivariate data that follow a latent factor structure
with censored errors (Normal, Student-t or Logistic).
}
\examples{
\donttest{
set.seed(2025)
obj <- censored_factor_models(200, 6, 2)
psych::KMO(obj$data)
}
}
