% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustering_functions.R
\name{test_hvg}
\alias{test_hvg}
\title{test_hvg}
\usage{
test_hvg(
  raw_counts,
  cluster,
  localized_genes,
  background,
  number_hvg,
  min_p_value
)
}
\arguments{
\item{raw_counts}{Raw count matrix (n_genes X n_cells).}

\item{cluster}{Vector of length equal to the number of cells, with cluster
assignment.}

\item{localized_genes}{Character vector with localized genes detected by CIARA.}

\item{background}{Character vector with all the genes names to use as
background for the Fisher test.}

\item{number_hvg}{Integer value. Number of top HVGs provided by the Seurat
function \emph{FindVariableFeatures}.}

\item{min_p_value}{Threshold on p values provided by Fisher test.}
}
\value{
A list with two elements. \item{first element}{The first one is a
list with length equal to the number of clusters. Each entry is list of
three elements. The first two elements contain the p value and the odds
ration given by the Fisher test The third is a vector with genes names that
are present both in \emph{localized_genes} and in top \emph{number_hvg} HVGs
.} \item{second element}{a character vector with the name of the cluster that
have a p value smaller than \emph{min_p_value}.}
}
\description{
For each cluster in \emph{cluster}, HVGs are defined with
Seurat function \emph{FindVariableFeatures}. A Fisher test is performed to
see if there is a statistically significant enrichment between the top
\emph{number_hvg} and the \emph{localized_genes}
}
\seealso{
\url{https://www.rdocumentation.org/packages/stats/versions/3.6.2/topics/fisher.test}
}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
