% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce_estimate_bart_ate.R
\name{ce_estimate_bart_ate}
\alias{ce_estimate_bart_ate}
\title{Causal inference with multiple treatments using BART for ATE effects}
\usage{
ce_estimate_bart_ate(y, x, w, discard = FALSE, ndpost = 1000, ...)
}
\arguments{
\item{y}{A numeric vector (0, 1) representing a binary outcome.}

\item{x}{A dataframe, including all the covariates but not treatments.}

\item{w}{A numeric vector representing the treatment groups.}

\item{discard}{A logical indicating whether to use the discarding rules.
The default is \code{FALSE}.}

\item{ndpost}{A numeric value indicating the number of posterior draws.}

\item{...}{Other parameters that can be passed through to functions.}
}
\value{
A summary of the effect estimates can be obtained
with \code{summary} function. The output also
contains a list of the posterior samples of causal estimands. When
\code{discard = TRUE}, the output contains number of discarded
individuals.
}
\description{
The function \code{ce_estimate_bart_ate} implements
BART to estimate ATE effect with
multiple treatments using observational data.
}
\references{
Sparapani R, Spanbauer C, McCulloch R
Nonparametric Machine Learning and
Efficient Computation with Bayesian Additive Regression Trees:
The BART R Package.
\emph{Journal of Statistical Software}, \strong{97}(1), 1-66.

Hadley Wickham, Romain François, Lionel Henry and Kirill Müller (2021).
\emph{dplyr: A Grammar of Data Manipulation}. R package version 1.0.7.
URL: \url{https://CRAN.R-project.org/package=dplyr}
}
