% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_clme.r
\name{summary.clme}
\alias{summary.clme}
\title{Produce summary values for objects of class \code{clme}}
\usage{
\method{summary}{clme}(object, nsim = 1000, seed = NULL, verbose = c(FALSE, FALSE), ...)
}
\arguments{
\item{object}{an object of class \code{clme}.}

\item{nsim}{the number of bootstrap samples to use for inference.}

\item{seed}{the value for the seed of the random number generator.}

\item{verbose}{vector of logicals. First element will print progress for bootstrap test,
second element is passed to the EM algorithm for every bootstrap sample.}

\item{...}{additional arguments passed to other functions.}
}
\value{
The output of \code{summary.clme} is an object of the class \code{summary.clme}. This is a list
containing the input object (of class \code{clme}), along with elements:
\item{\code{p.value}}{ p-value for the global hypothesis}
\item{\code{p.value.ind}}{ p-values for each of the constraints}
}
\description{
Summarizes the output of objects of class \code{clme}, such as those produced by \code{\link{clme}}.
}
\examples{
\dontrun{
  set.seed( 42 )
  data( rat.blood )
  cons <- list(order = "simple", decreasing = FALSE, node = 1 )
  clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood , 
                   constraints = cons, seed = 42, nsim = 10)
  
  summary( clme.out )
}


}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}
}
