% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_ehv_switchgear.R
\name{financial_cof_ehv_switchgear}
\alias{financial_cof_ehv_switchgear}
\title{Financial cost of Failure for EHV swicthgear & 132kV CB}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
financial_cof_ehv_switchgear(ehv_asset_category, access_factor_criteria)
}
\arguments{
\item{ehv_asset_category}{String The type of EHV swicthgear & 132kV CB
Options: \code{ehv_asset_category = c(
"33kV CB (Air Insulated Busbars)(ID)(GM)",
"33kV CB (Air Insulated Busbars)(OD)(GM)",
"33kV CB (Gas Insulated Busbars)(ID)(GM)",
"33kV CB (Gas Insulated Busbars)(OD)(GM)",
"33kV RMU",
"33kV Switch (GM)",
"66kV CB (Air Insulated Busbars)(ID)(GM)",
"66kV CB (Air Insulated Busbars)(OD)(GM)",
"66kV CB (Gas Insulated Busbars)(ID)(GM)",
"66kV CB (Gas Insulated Busbars)(OD)(GM)")}}

\item{access_factor_criteria}{String. Asses Financial factor criteria for EHV swicthgear & 132kV CB
setting (cf. table 221, page 180, CNAIM, 2021).
Options: \code{access_factor_criteria = c("Type A", "Type B", "Type C")}.}
}
\value{
Numeric. Financial consequences of failure for EHV swicthgear & 132kV CB
}
\description{
This function calculates financial consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Financial consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
financial_cof_ehv_switchgear(ehv_asset_category = "33kV RMU", access_factor_criteria = "Type A")
}
