% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_switchgear_secondary_10kv.R
\name{pof_switchgear_secondary_10kV}
\alias{pof_switchgear_secondary_10kV}
\title{Current Probability of Failure for 10kV Switchgear secondary}
\usage{
pof_switchgear_secondary_10kV(
  placement = "Default",
  altitude_m = "Default",
  distance_from_coast_km = "Default",
  corrosion_category_index = "Default",
  age,
  measured_condition_inputs,
  observed_condition_inputs,
  reliability_factor = "Default",
  k_value = 0.0067,
  c_value = 1.087,
  normal_expected_life = 55
)
}
\arguments{
\item{placement}{String. Specify if the asset is located outdoor or indoor.}

\item{altitude_m}{Numeric. Specify the altitude location for
the asset measured in meters from sea level.\code{altitude_m}
is used to derive the altitude factor. A setting of \code{"Default"}
will set the altitude factor to 1 independent of \code{asset_type}.}

\item{distance_from_coast_km}{Numeric. Specify the distance from the
coast measured in kilometers. \code{distance_from_coast_km} is used
to derive the distance from coast factor. A setting of \code{"Default"} will set the
 distance from coast factor to 1 independent of \code{asset_type}.}

\item{corrosion_category_index}{Integer.
Specify the corrosion index category, 1-5.}

\item{age}{Numeric. The current age in years of the conductor.}

\item{measured_condition_inputs}{Named list observed_conditions_input}

\item{observed_condition_inputs}{Named list observed_conditions_input
\code{conductor_samp = c("Low","Medium/Normal","High","Default")}.}

\item{reliability_factor}{Numeric. \code{reliability_factor}
shall have a value between 0.6 and 1.5. A setting of \code{"Default"}
 sets the \code{reliability_factor} to 1.
See section 6.14 on page 73 in CNAIM (2021).}

\item{k_value}{Numeric. \code{k_value = 0.0067} by default. This number is
given in a percentage. The default value is accordingly to the CNAIM standard
on p. 110.}

\item{c_value}{Numeric. \code{c_value = 1.087} by default.
The default value is accordingly to the CNAIM standard see page 110}

\item{normal_expected_life}{Numeric. \code{normal_expected_life = 55} by default.
The default value is accordingly to the CNAIM standard on page 107.}
}
\value{
DataFrame Current probability of failure
per annum per kilometer along with current health score.
}
\description{
This function calculates the current
annual probability of failure 10kV Switchgear secondary
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function.
}
\examples{
# Current annual probability of failure for 10kV Swicthgear secondary
pof_switchgear_secondary_10kV(
placement = "Default",
altitude_m = "Default",
distance_from_coast_km = "Default",
corrosion_category_index = "Default",
age = 10,
observed_condition_inputs =
list("external_condition" =
list("Condition Criteria: Observed Condition" = "Default"),
"oil_gas" = list("Condition Criteria: Observed Condition" = "Default"),
"thermo_assment" = list("Condition Criteria: Observed Condition" = "Default"),
"internal_condition" = list("Condition Criteria: Observed Condition" = "Default"),
"indoor_env" = list("Condition Criteria: Observed Condition" = "Default")),
measured_condition_inputs =
list("partial_discharge" =
list("Condition Criteria: Partial Discharge Test Results" = "Default"),
"ductor_test" = list("Condition Criteria: Ductor Test Results" = "Default"),
"oil_test" = list("Condition Criteria: Oil Test Results" = "Default"),
"temp_reading" = list("Condition Criteria: Temperature Readings" = "Default"),
"trip_test" = list("Condition Criteria: Trip Timing Test Result" = "Default")),
reliability_factor = "Default",
k_value = 0.0067,
c_value = 1.087,
normal_expected_life = 55)
}
