% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSegs.R
\name{readSegs}
\alias{readSegs}
\title{readSegs}
\usage{
readSegs(path, colMap = NULL, readPloidy = FALSE)
}
\arguments{
\item{path}{The path to the .txt file with the data in it, or a folder
containing the .txt files}

\item{colMap}{The mapping of column names. The default is 
c("ID","chromosome","start","end","segVal"). If your column names vary 
from this please pass a vector similar to the above with the changes.}

\item{readPloidy}{Whether or not the input file has ploidy and should be read}
}
\value{
Returns a segments in a list formatted to be run through the pipeline
}
\description{
This function is used to read in the segments. It can either take a file
path to a csv to read in the data, or it can take in a long data frame
and convert it to the format needed for the pipeline. The variable colMap is
used in order to map your column names to what the pipeline expects. For 
instance, if your column that has the chromosome numbers in it is titled 
"chrom" instead of the expected "chromosome" then you would specify the colMap
as c("ID","chrom","start","end","segVal"). If your data is seperated into 
major and minor allele copy numbers then for the segVal part of the colMap 
should be formatted as "nMajor+nMinor" to let the function know to add them
together.
}
