% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{Impute.purse}
\alias{Impute.purse}
\title{Impute data sets in a purse}
\usage{
\method{Impute}{purse}(
  x,
  dset,
  f_i = NULL,
  f_i_para = NULL,
  impute_by = "column",
  group_level = NULL,
  use_group = NULL,
  normalise_first = NULL,
  write_to = NULL,
  warn_on_NAs = TRUE,
  ...
)
}
\arguments{
\item{x}{A purse object}

\item{dset}{The name of the data set to apply the function to, which should be accessible in \code{.$Data}.}

\item{f_i}{An imputation function. For the "purse" class, if \verb{f_i = "impute_panel} this is a special
case: see details.}

\item{f_i_para}{Further arguments to pass to \code{f_i}, other than \code{x}. See details.}

\item{impute_by}{Specifies how to impute: if \code{"column"}, passes each column (indicator) separately as a numerical
vector to \code{f_i}; if \code{"row"}, passes each \emph{row} separately; and if \code{"df"} passes the entire data set (data frame) to
\code{f_i}. The function called by \code{f_i} should be compatible with the type of data passed to it.}

\item{group_level}{A level of the framework to use for grouping indicators. This is only
relevant if \code{impute_by = "row"} or \code{"df"}. In that case, indicators will be split into their groups at the
level specified by \code{group_level}, and imputation will be performed across rows of the group, rather
than the whole data set. This can make more sense because indicators within a group are likely to be
more similar.}

\item{use_group}{Optional grouping variable name to pass to imputation function if this supports group
imputation.}

\item{normalise_first}{Logical: if \code{TRUE}, each column is normalised using a min-max operation before
imputation. By default this is \code{FALSE} unless \code{impute_by = "row"}. See details.}

\item{write_to}{Optional character string for naming the resulting data set in each coin. Data will be written to
\code{.$Data[[write_to]]}. Default is \code{write_to == "Imputed"}.}

\item{warn_on_NAs}{Logical: if \code{TRUE} will issue a warning if there are any \code{NA}s detected in the data frame
after imputation has been applied. Set \code{FALSE} to suppress these warnings.}

\item{...}{arguments passed to or from other methods.}
}
\value{
An updated purse with imputed data sets added to each coin.
}
\description{
This function imputes the target data set \code{dset} in each coin using the imputation function \code{f_i}. This is performed
in the same way as the coin method \code{\link[=Impute.coin]{Impute.coin()}}, but with one "special case" for panel data. If \verb{f_i = "impute_panel},
the data sets inside the purse are imputed using the \code{\link[=impute_panel]{impute_panel()}}
function. In this case, coins are not imputed individually, but treated as a single data set. In this
case, optionally set the imputation method as \code{f_i_para = list(imp_type = .)}
and \code{f_i_para = list(max_time = .)} where \code{.} should be substituted with the maximum
number of time points to search backwards for a non-\code{NA} value. See \code{\link[=impute_panel]{impute_panel()}} for more details.
No further arguments need to be passed to \code{\link[=impute_panel]{impute_panel()}}. See \code{vignette("imputation")} for more
details. See also \code{\link[=Impute.coin]{Impute.coin()}} documentation.
}
\examples{
# see vignette("imputation")
}
