% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treat.R
\name{Treat.purse}
\alias{Treat.purse}
\title{Treat a purse of coins for outliers}
\usage{
\method{Treat}{purse}(
  x,
  dset,
  global_specs = NULL,
  indiv_specs = NULL,
  combine_treat = FALSE,
  write_to = NULL,
  disable = FALSE,
  ...
)
}
\arguments{
\item{x}{A purse object}

\item{dset}{The data set to treat in each coin.}

\item{global_specs}{Default specifications. See details in \code{\link[=Treat.coin]{Treat.coin()}}.}

\item{indiv_specs}{Individual specifications. See details in \code{\link[=Treat.coin]{Treat.coin()}}.}

\item{combine_treat}{By default, if \code{f1} fails to pass \code{f_pass}, then \code{f2} is applied to the original \code{x},
rather than the treated output of \code{f1}. If \code{combine_treat = TRUE}, \code{f2} will instead be applied to the output
of \code{f1}, so the two treatments will be combined.}

\item{write_to}{If specified, writes the aggregated data to \code{.$Data[[write_to]]}. Default \code{write_to = "Treated"}.}

\item{disable}{Logical: if \code{TRUE} will disable data treatment completely and write the unaltered data set. This option is mainly useful
in sensitivity and uncertainty analysis (to test the effect of turning imputation on/off).}

\item{...}{arguments passed to or from other methods.}
}
\value{
An updated purse with new treated data sets added at \code{.$Data$Treated} in each coin, plus
analysis information at \code{.$Analysis$Treated}
}
\description{
This function calls \code{\link[=Treat.coin]{Treat.coin()}} for each coin in the purse. See the documentation of that function for
details. See also \code{vignette("treat")}.
}
\examples{
# See `vignette("treat")`.
}
