% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{a_genmean}
\alias{a_genmean}
\title{Weighted generalised mean}
\usage{
a_genmean(x, w = NULL, p)
}
\arguments{
\item{x}{A numeric vector of positive values.}

\item{w}{A vector of weights, which should have length equal to \code{length(x)}. Weights are relative
and will be re-scaled to sum to 1. If \code{w} is not specified, defaults to equal weights.}

\item{p}{Coefficient - see details.}
}
\value{
Weighted harmonic mean, as a numeric value.
}
\description{
Weighted generalised mean of a vector. \code{NA} are skipped by default.
}
\details{
The generalised mean is as follows:

\deqn{ y = \left( \frac{1}{\sum w_i} \sum w_i x_i^p  \right)^{1/p} }

where \code{p} is a coefficient specified in the function argument here. Note that:
\itemize{
\item For negative \code{p}, all \code{x} values must be positive
\item Setting \code{p = 0} will result in an error due to the negative exponent. This case
is equivalent to the geometric mean in the limit, so use \code{\link[=a_gmean]{a_gmean()}} instead.
}
}
\examples{
# a vector of values
x <- 1:10
# a vector of weights
w <- runif(10)
# cubic mean
a_genmean(x,w, p = 2)

}
