% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{get_results}
\alias{get_results}
\title{Results summary tables}
\usage{
get_results(
  coin,
  dset,
  tab_type = "Summ",
  also_get = NULL,
  use = "scores",
  order_by = NULL,
  nround = 2,
  use_group = NULL,
  dset_indicators = NULL,
  out2 = "df"
)
}
\arguments{
\item{coin}{The coin object, or a data frame of indicator data}

\item{dset}{Name of data set in \code{.$Data}}

\item{tab_type}{The type of table to generate. Either \code{"Summ"} (a single indicator plus rank), \code{"Aggs"} (all aggregated
scores/ranks above indicator level), or \code{"Full"} (all scores/ranks plus all group, denominator columns).}

\item{also_get}{Names of further columns to attach to table.}

\item{use}{Either \code{"scores"} (default), \code{"ranks"}, or \code{"groupranks"}. For the latter, \code{use_group} must be specified.}

\item{order_by}{A code of the indicator or aggregate to sort the table by. If not specified, defaults to the highest
aggregate level, i.e. the index in most cases. If \code{use_group} is specified, rows will also be sorted by the specified group.}

\item{nround}{The number of decimal places to round numerical values to. Defaults to 2.}

\item{use_group}{An optional grouping variable. If specified, the results table includes this group column,
and if \code{use = "groupranks"}, ranks will be returned with respect to the groups in this column.}

\item{dset_indicators}{Optional data set from which to take only indicator (level 1) data from. This can be set to \code{"Raw"}
for example, so that all aggregates come from the aggregated data set, and the indicators come from the raw data set. This
can make more sense in presenting results in many cases, so that the "real" indicator data is visible.}

\item{out2}{If \code{"df"}, outputs a data frame (tibble). Else if \code{"coin"} attaches to \code{.$Results} in an updated coin.}
}
\value{
If \code{out2 = "df"}, the results table is returned as a data frame. If \code{out2 = "coin"}, this function returns an updated
coin with the results table attached to \code{.$Results}.
}
\description{
Generates fast results tables, either attached to the coin or as a data frame.
}
\details{
Although results are available in a coin in \code{.$Data}, the format makes it difficult to quickly present results. This function
generates results tables that are suitable for immediate presentation, i.e. sorted by index or other indicators, and only including
relevant columns. Scores are also rounded by default, and there is the option to present scores or ranks.

See also \code{vignette("results")} for more info.

This function replaces the now-defunct \code{getResults()} from COINr < v1.0.
}
\examples{
# build full example coin
coin <- build_example_coin(quietly = TRUE)

# get results table
df_results <- get_results(coin, dset = "Aggregated", tab_type = "Aggs")

head(df_results)

}
