% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zicmp-reg.R
\name{glm.cmp, ZICMP support}
\alias{glm.cmp, ZICMP support}
\alias{summary.zicmpfit}
\alias{print.zicmpfit}
\alias{logLik.zicmpfit}
\alias{AIC.zicmpfit}
\alias{BIC.zicmpfit}
\alias{coef.zicmpfit}
\alias{nu.zicmpfit}
\alias{sdev.zicmpfit}
\alias{vcov.zicmpfit}
\alias{equitest.zicmpfit}
\alias{deviance.zicmpfit}
\alias{residuals.zicmpfit}
\alias{predict.zicmpfit}
\alias{parametric.bootstrap.zicmpfit}
\title{Supporting Functions for ZICMP Regression}
\usage{
\method{summary}{zicmpfit}(object, ...)

\method{print}{zicmpfit}(x, ...)

\method{logLik}{zicmpfit}(object, ...)

\method{AIC}{zicmpfit}(object, ..., k = 2)

\method{BIC}{zicmpfit}(object, ...)

\method{coef}{zicmpfit}(object, type = c("vector", "list"), ...)

\method{nu}{zicmpfit}(object, ...)

\method{sdev}{zicmpfit}(object, type = c("vector", "list"), ...)

\method{vcov}{zicmpfit}(object, ...)

\method{equitest}{zicmpfit}(object, ...)

\method{deviance}{zicmpfit}(object, ...)

\method{residuals}{zicmpfit}(object, type = c("raw", "quantile"), ...)

\method{predict}{zicmpfit}(object, newdata = NULL, type = c("response", "link"), ...)

\method{parametric.bootstrap}{zicmpfit}(object, reps = 1000, report.period = reps + 1, ...)
}
\arguments{
\item{object}{object of type \code{zicmp}.}

\item{...}{other arguments, such as \code{subset} and \code{na.action}.}

\item{x}{object of type \code{zicmp}.}

\item{k}{Penalty per parameter to be used in AIC calculation.}

\item{type}{Specifies quantity to be computed. See details.}

\item{newdata}{New covariates to be used for prediction.}

\item{reps}{Number of bootstrap repetitions.}

\item{report.period}{Report progress every \code{report.period} iterations.}
}
\description{
Supporting Functions for ZICMP Regression
}
\details{
The function \code{residuals} returns raw residuals when
\code{type = "raw"}  and quantile residuals when
\code{type = "quantile"}.

The function \code{predict} returns expected values of the outcomes,
eveluated at the computed estimates, when \code{type = "response"}. When
\code{type = "link"}, a \code{data.frame} is instead returned with
columns corresponding to estimates of \code{lambda}, \code{nu}, and
\code{p}.

The function \code{coef} returns a vector of coefficient estimates in
the form \code{c(beta, gamma, zeta)} when \code{type = "vector"}. When
\code{type = "list"}, the estimates are returned as a list with named
elements \code{beta} and \code{gamma}, and \code{zeta}.

The \code{type} argument behaves the same for the \code{sdev} function
as it does for \code{coef}.
}
