\name{CP-package}

\alias{CP-package}

\alias{CP}

\docType{package}

\title{
 Conditional Power Calculations
}

\description{
 This package provides several functions for calculating the conditional power
 for different models in survival time analysis
 within randomized clinical trials
 with two different treatments to be compared
 and survival as an endpoint.
}

\details{
 \tabular{ll}{
  Package: \tab CP \cr
  Type:    \tab Package \cr
  Version: \tab 1.8 \cr
  Date:    \tab 2023-05-17 \cr
  License: \tab GPL-3 \cr
 }
 
 This package could be some help
 when you want to calculate the conditional power
 at the time of an interim analysis
 of a randomized clinical trial with survival as an endpoint.
 
 The conditional power is defined as the probability
 of obtaining a significant result at the end of the trial
 when the real effect is equal to the expected effect
 given the data from the interim analysis.
 
 Functions for the model with exponential survival (\code{\link{ConPwrExp}})
 and the non-mixture models with exponential (\code{\link{ConPwrNonMixExp}}),
 Weibull type (\code{\link{ConPwrNonMixWei}})
 and Gamma type survival (\code{\link{ConPwrNonMixGamma}}) are provided.
 
 There is also the function \code{\link{CompSurvMod}}
 to compare the four mentioned models.
 
 Additionally, there is also a function for the exponential model
 with the original formulae of the Andersen paper
 (\code{\link{ConPwrExpAndersen}}).
 
 Finally, the user is able to generate further data frames
 by random via \code{\link{GenerateDataFrame}}.
}

\note{
 The theoretical results of this implementation
 are based on some assumptions. \cr
 Non-Mixture-Exponential: \eqn{\lambda[1] = \lambda[2]} \cr
 Non-Mixture-Weibull: \eqn{\lambda[1] = \lambda[2]} and \eqn{k[1] = k[2]} \cr
 Non-Mixture-Gamma: \eqn{a[1] = a[2]} and \eqn{b[1] = b[2]}
 
 In general, such assumptions are not fulfilled when using real data.
 
 Nevertheless, when doing conditional power calculations
 the situation is that you have no significant difference
 at the time of interim analysis.
 In this case, no treatment arm is superior to the other one.
 Thus, the assumptions named above are approximately satisfied.
 
 In contrast to this, caution should be exercised
 when calculating the conditional power
 in the case of significant results at the time of interim analysis.  
}

\author{
 Andreas Kuehnapfel

 Maintainer: Andreas Kuehnapfel <andreas.kuehnapfel@imise.uni-leipzig.de>
}

\references{
 Andreas Kuehnapfel, Fabian Schwarzenberger, Markus Scholz.
 On the Conditional Power in Survival Time Analysis
 Considering Cure Fractions.
 The International Journal of Biostatistics 13 (1), 2017.
 
 Per Kragh Andersen.
 Conditional power calculations as an aid in the decision
 whether to continue a clinical trial.
 Controlled Clinical Trials 8 (1), 67-74, 1987.
}

\seealso{
 \code{\link{ConPwrExp}} \cr
 \code{\link{ConPwrNonMixExp}} \cr
 \code{\link{ConPwrNonMixWei}} \cr 
 \code{\link{ConPwrNonMixGamma}} \cr
 \code{\link{CompSurvMod}} \cr
 \code{\link{ConPwrExpAndersen}} \cr
 \code{\link{GenerateDataFrame}} \cr
 \code{\link{test}}
}

\examples{
 # data frame 'test' generated by 'GenerateDataFrame'
 
 # conditional power calculations
 # within the exponential model
 ConPwrExp(data = test, cont.time = 12, new.pat = c(2.5, 2.5),
           theta.0 = 0.75, alpha = 0.05,
           disp.data = TRUE, plot.km = TRUE)
           
 # conditional power calculations
 # within the non-mixture model with exponential survival
 ConPwrNonMixExp(data = test, cont.time = 12, new.pat = c(2.5, 2.5),
                 theta.0 = 0.75, alpha = 0.05,
                 disp.data = TRUE, plot.km = TRUE)
                 
 # conditional power calculations
 # within the non-mixture model with Weibull type survival
 ConPwrNonMixWei(data = test, cont.time = 12, new.pat = c(2.5, 2.5),
                 theta.0 = 0.75, alpha = 0.05,
                 disp.data = TRUE, plot.km = TRUE)
                
 # conditional power calculations
 # within the non-mixture model with Gamma type survival
 ConPwrNonMixGamma(data = test, cont.time = 12, new.pat = c(2.5, 2.5),
                   theta.0 = 0.75, alpha = 0.05,
                   disp.data = TRUE, plot.km = TRUE)
                   
 # conditional power calculations
 # within the four mentioned models
 CompSurvMod(data = test, cont.time = 12, new.pat = c(2.5, 2.5),
             theta.0 = 0.75, alpha = 0.05,
             disp.data = TRUE, plot.km = TRUE)
 
 # conditional power calculations
 # within the exponential model
 # with the original formulae of the Andersen paper
 ConPwrExpAndersen(data = test, cont.time = 12, new.pat = c(2.5, 2.5),
                   theta.0 = 0.75, alpha = 0.05,
                   disp.data = TRUE, plot.km = TRUE)
}